/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "sexpr.h"
#include "dfile_exec.h"


int completed_status( int *completed_successful_flag, int *status, completed_t *completed, unsigned long completed_cnt, const char *partition_text, const char *step_name, const unsigned char *successful_exit_code )
{
	int	exit_code;
	completed_t	completed_key, *completed_search;

	assert( completed_successful_flag != (int *)0 );
	assert( status != (int *)0 );
	assert( step_name != (const char *)0 );
	assert( successful_exit_code != (const unsigned char *)0 );

	/*
	** Initialize completed_successful_flag to false.
	*/
	*completed_successful_flag = 0;

	completed_key.step_name = step_name;
	completed_key.partition = partition_text;

#if 0
fprintf( stderr, "step [%s], partition, [%s]\n", step_name, partition_text );
#endif

	assert( completed != (completed_t *)0 );

	completed_search = (completed_t *)nubsearch( (void *)&completed_key, (void *)completed, (size_t)completed_cnt, sizeof( completed_t ), completed_cmp );

	while ( completed_search != (completed_t *)0 ) {
		exit_code = completed_search->exit_code;
		*status = exit_code;

#if 0
fprintf(stderr, "exit_code %d\n", exit_code );
#endif

		if ( exit_code < 0 || exit_code > UCHAR_MAX ) {
			fput_src_code( __FILE__, __LINE__, stderr );
			(void) fputs( "Encountered exit code [", stderr );
			(void) fput_int( exit_code, stderr );
			(void) fputs( "] not between 0 and ", stderr );
			(void) fput_int( UCHAR_MAX, stderr );
			(void) fputs( ".\n", stderr );
			RETURN_INT( -1 );
		}

		if ( successful_exit_code[ exit_code ] ) {
			/*
			** This process was previously
			** successfully run.
			** Initialize completed_successful_flag to true.
			*/
			*completed_successful_flag = 1;
#if 0
fputs( "This process was previously run.\n", stderr );
#endif
			RETURN_INT( 0 );
		}

		completed_search = (completed_t *)nubsearch_next( (void *)completed_search, (void *)completed, (size_t)completed_cnt, sizeof( completed_t ), completed_cmp );
	}

	RETURN_INT( 0 );
}
