/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "sexpr.h"
#include "dfile_exec.h"


/*
** This function releases unneeded proc slots that were previously allocated.
*/
int release_allocated_procs( unsigned short unneeded_proc_cnt, int semid )
{
	int	ret;
	struct sembuf	sops;

	DEBUG_FUNC_START;

	ret = 0;

	sops.sem_num = 0;
	sops.sem_op = unneeded_proc_cnt;
	sops.sem_flg = SEM_UNDO;

	if ( semop( semid, &sops, (size_t)1 ) == -1 ) {
		UNIX_ERROR( "semop() failed" );
		ret = -1;
	}

	RETURN_INT( ret );
}
