/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"
#include "sexpr.h"
#include "dfile_join.h"


/*
** This function copies a stored record to a bind structure.
*/
void copy_shm_record_to_bind( dfile_bind_t **bind, unsigned long matched_record_offset, shm_t *shm, const unsigned short *from_field_ndx_tbl, unsigned short field_ndx_tbl_cnt )
{
	dfile_bind_t	*bind_ptr;
	const char	*record, *field;
	const size_t	*field_offset;
	size_t	offset;

	assert( bind != (dfile_bind_t **)0 );
	assert( shm != (shm_t *)0 );
	/*
	** from_field_ndx_tbl and bind can be null
	** when no fields need copying to output (field_ndx_tbl_cnt is zero).
	*/

	DEBUG_FUNC_START;

	record = &shm->data[ shm->rec_size * matched_record_offset ];
	field_offset = shm->field_offset;

	for ( ; field_ndx_tbl_cnt > (unsigned short)0; --field_ndx_tbl_cnt ) {
		offset = field_offset[ *from_field_ndx_tbl ];
		field = &record[ offset ];
		bind_ptr = *bind;
		*bind_ptr->field_buffer = (char *)field;
		*bind_ptr->field_length = strlen( field );
		++bind;
		++from_field_ndx_tbl;
	}

	RETURN_VOID;
}
