/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"
#include "sexpr.h"
#include "dfile_join.h"


/*
** This function writes join results.
*/
int write_join( dfile_t *dfile, join_ctl_t *join, unsigned short join_ndx, void *output_filter )
{
	unsigned long	ndx;

	assert( dfile != (dfile_t *)0 );
	assert( join != (join_ctl_t *)0 );

	DEBUG_FUNC_START;

	if ( join->record_cnt == 0UL ) {
		null_fields( join->output_field_tbl, join->copy_field_tbl_cnt );

		if ( join_ndx == (unsigned short)0 ) {
			/*
			** Reached end of join stack.
			*/
			if ( write_record( dfile, output_filter ) == -1 ) {
				RETURN_INT( -1 );
			}
		} else {
			if ( write_join( dfile, &join[ 1 ], join_ndx - (unsigned short)1, output_filter ) == -1 ) {
				RETURN_INT( -1 );
			}
		}

		RETURN_INT( 0 );
	}

	if ( join->unique_join_flag != (char)0 ) {
		switch ( join->unique_join_flag ) {
		case 'F':
			/*
			** Join first record only.
			*/
			if ( join->ipc_key == (const char *)0 ) {
				copy_record_to_bind( join->output_field_tbl, join->copy_record[ 0 ], join->copy_field_tbl_cnt );
			} else {
				copy_shm_record_to_bind( join->output_field_tbl, join->shm.matched_record_offset, &join->shm, join->join_field_ndx_tbl, join->copy_field_tbl_cnt );
			}
			break;

		case 'L':
			/*
			** Join last record only.
			*/
			assert( join->record_cnt > 0UL );

			if ( join->ipc_key == (const char *)0 ) {
				copy_record_to_bind( join->output_field_tbl, join->copy_record[ join->record_cnt - 1UL ], join->copy_field_tbl_cnt );
			} else {
				copy_shm_record_to_bind( join->output_field_tbl, join->shm.matched_record_offset + join->record_cnt - 1UL, &join->shm, join->join_field_ndx_tbl, join->copy_field_tbl_cnt );
			}
			break;

		default:
			(void) fputs( "Programming error: unique_join_flag value is unexpected [", stderr );
			(void) fputc( join->unique_join_flag, stderr );
			(void) fputs( "].\n", stderr );
			abort();
		}

		if ( join_ndx == (unsigned short)0 ) {
			/*
			** Reached end of join stack.
			*/
			if ( write_record( dfile, output_filter ) == -1 ) {
				RETURN_INT( -1 );
			}
		} else {
			if ( write_join( dfile, &join[ 1 ], join_ndx - (unsigned short)1, output_filter ) == -1 ) {
				RETURN_INT( -1 );
			}
		}

		RETURN_INT( 0 );
	}

	for ( ndx = 0UL; ndx < join->record_cnt; ++ndx ) {
		if ( join->ipc_key == (const char *)0 ) {
			copy_record_to_bind( join->output_field_tbl, join->copy_record[ ndx ], join->copy_field_tbl_cnt );
		} else {
			copy_shm_record_to_bind( join->output_field_tbl, join->shm.matched_record_offset + ndx, &join->shm, join->join_field_ndx_tbl, join->copy_field_tbl_cnt );
		}

		if ( join_ndx == (unsigned short)0 ) {
			/*
			** Reached end of join stack.
			*/
			if ( write_record( dfile, output_filter ) == -1 ) {
				RETURN_INT( -1 );
			}
		} else {
			if ( write_join( dfile, &join[ 1 ], join_ndx - (unsigned short)1, output_filter ) == -1 ) {
				RETURN_INT( -1 );
			}
		}
	}

	RETURN_INT( 0 );
}
