/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"


/*
** This function formats a field to be part of an escaped record. Embedded
** field and record separator characters found in data must be prefixed by an
** escape character. Length of field is provided by caller.
*/

int _dfile_format_escaped_field( char **buf_ptr, const char *buf_ptr_end, const char **value, size_t *value_length, dfile_rec_t rec_attribute )
{
	register char	*ptr, field_separator, record_separator;
	register const char	*str;
	register size_t	length;

	assert( buf_ptr != (char **)0 );
	assert( *buf_ptr != (char *)0 );
	assert( buf_ptr_end != (char *)0 );
	assert( value != (const char **)0 );
	assert( *value != (const char *)0 );
	assert( value_length != (size_t *)0 );

	ptr = *buf_ptr;
	str = *value;
	field_separator = rec_attribute.field_separator;
	record_separator = rec_attribute.record_separator;

	for ( length = *value_length; length > (size_t)0; --length ) {
		if ( ptr >= buf_ptr_end ) {
			*buf_ptr = ptr;
			*value = str;
			*value_length = length;
			return -1;
		}

		if ( *str == field_separator || *str == record_separator ) {
			/*
			** Separator character found in data.
			** Insert escape character prior to
			** separator character.
			*/
			if ( &ptr[ 1 ] >= buf_ptr_end ) {
				/*
				** Not enough space in buffer for both
				** characters.
				*/
				*buf_ptr = ptr;
				*value = str;
				*value_length = length;
				return -1;
			}
			*ptr = rec_attribute.separator_escape;
			++ptr;
		}

		*ptr = *str;
		++ptr;
		++str;
	}

	if ( ptr > *buf_ptr ) {
		/*
		** Copied at least one character. Make sure last character of
		** field is not separator_escape character.
		*/
		--ptr;
		if ( *ptr == rec_attribute.separator_escape ) {
			/*
			** Cannot have last character of field be
			** separator_escape character. Convert
			** separator_escape character to space.
			*/
			*ptr = ' ';
		}
		++ptr;
	}

	*buf_ptr = ptr;
	*value = str;
	*value_length = length;

	return 0;
}
