/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"


/*
** This function is called when end of file is reached.
*/

void _dfile_read_eof_processing( dfile_t *dfile, dfile_buffer_t *buffer )
{

	assert( dfile != (dfile_t *)0 );
	assert( buffer != (dfile_buffer_t *)0 );

	DEBUG_FUNC_START;

	switch ( dfile->record_type ) {
	case Dfile_variable_length:
		if ( dfile->read_var_rec.current_bind == (dfile_bind_t *)0 ) {
			dfile->error = Dfile_all_data_processed;
			if ( Debug ) {
				(void) fputs( "Set dfile->error to Dfile_all_data_processed.\n", stderr );
			}
		} else {
			/*
			** File is corrupt since last record in file does
			** not have correct number of fields.
			*/
			dfile->error = Dfile_partial_record;
			if ( Debug ) {
				(void) fputs( "Set dfile->error to Dfile_partial_record.\n", stderr );
			}
		}
		break;

	case Dfile_delimited:
		if ( dfile->file_rec_cnt == 0UL || dfile->file_rec_cnt > dfile->parse_fail_rec_cnt ) {
			dfile->error = Dfile_all_data_processed;
		} else {
			dfile->error = Dfile_invalid_record_layout;
		}
		break;

	default:
		FPUT_SRC_CODE( stderr );
		(void) fputs( "Unknown record type encountered, [", stderr );
		(void) fput_int( dfile->record_type, stderr );
		(void) fputs( "].\n", stderr );
	}

	RETURN_VOID;
}
