/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_dynamic.h"


/*
** This function assigns field offsets within the record layout.
*/
int assign_field_offset( unsigned short **ret_key_ndx_tbl, char **key_tbl, unsigned short key_tbl_cnt, dfile_bind_t *bind_tbl, dfile_bind_t **sorted_bind, unsigned short sorted_bind_cnt )
{
	unsigned short ndx, *key_ndx_tbl;
	size_t	alloc_size;
	dfile_bind_t	bind, *key, **bind_entry;

	assert( ret_key_ndx_tbl != (unsigned short **)0 );
	assert( key_tbl != (char **)0 );
	assert( bind_tbl != (dfile_bind_t *)0 );
	assert( sorted_bind != (dfile_bind_t **)0 );

	DEBUG_FUNC_START;

	*ret_key_ndx_tbl = (unsigned short *)0;

	alloc_size = sizeof( unsigned short ) * (size_t)key_tbl_cnt;
	key_ndx_tbl = (unsigned short *)malloc( alloc_size );
	if ( key_ndx_tbl == (unsigned short *)0 ) {
		UNIX_ERROR( "malloc() failed" );
		RETURN_INT( -1 );
	}

	key = &bind;

	for ( ndx = (unsigned short)0; ndx < key_tbl_cnt; ++ndx ) {
		bind.field_name = key_tbl[ ndx ];

		bind_entry = (dfile_bind_t **)bsearch( (void *)&key, (void *)sorted_bind, (size_t)sorted_bind_cnt, sizeof( dfile_bind_t * ), dfile_bind_field_name_cmp );

		if ( bind_entry == (dfile_bind_t **)0 ) {
			FPUT_SRC_CODE( stderr );
			(void) fputs( "Key field [", stderr );
			(void) fputs( key_tbl[ ndx ], stderr );
			(void) fputs( "] was not defined as a DFile field.\n", stderr );
			RETURN_INT( -1 );
		}

		assert( *bind_entry >= bind_tbl );

		key_ndx_tbl[ ndx ] = (unsigned short)( *bind_entry - bind_tbl );
	}

	*ret_key_ndx_tbl = key_ndx_tbl;

	RETURN_INT( 0 );
}
