/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "sexpr.h"
#include "dfile.h"
#include "where.h"
#include "_where.h"


/*
** This function is part of the interpreter to evaluate an IN expression.
*/

int _where_in_condition( where_result_t *result, in_cond_t *in_cond )
{
	void	*hash_bucket, *value;

	assert( result != (where_result_t *)0 );
	assert( in_cond != (in_cond_t *)0 );

	DEBUG_FUNC_START;

	value = (void *)*in_cond->dfile_bind->field_buffer;

	hash_bucket = dhfind( value, (void *)in_cond->hash_table, strhkey( (char *)value ), (int (*)(const void *, const void *))strcmp );

	*result = ( hash_bucket == (void *)0 ) ? Where_result_false : Where_result_true;

	if ( Debug ) {
		if ( *result == Where_result_false ) {
			(void) fputs( "result is false\n", stderr );
		} else {
			(void) fputs( "result is true\n", stderr );
		}
	}

	RETURN_INT( WHERE_NOERR );
}
