/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "sexpr.h"
#include "where.h"
#include "dcat.h"


/*
** This program displays dfile data.
*/
int main( int argc, char **argv )
{
	const unsigned short	blocks_per_buffer_cnt = 2;
	const unsigned short	buffer_cnt = 1;

	const char	*dfile_name, *filter_file;
	char		field_separator, heading_flag, err_msg[256];
	dfile_t		*dfile;
	dfile_tag_t	*tag_tbl;
	unsigned short	tag_tbl_cnt;
	dfile_cfg_t	cfg;
	dfile_bind_t	*bind_tbl;
	unsigned short	ndx;
	void	*filter;
	where_result_t	where_result;

	if ( get_args( argc, argv, &dfile_name, &tag_tbl, &tag_tbl_cnt, &heading_flag, &field_separator, &filter_file ) == -1 ) {
		return 10;
	}

	DEBUG_FUNC_START;

	if ( dfile_cfg( &cfg, dfile_name ) == -1 ) {
		RETURN_INT( 10 );
	}

	if ( heading_flag == 'Y' ) {
		/*
		** Print field name heading.
		*/
		for ( ndx = 0; ndx < cfg.field_name_cnt - 1; ++ndx ) {
			(void) fputs( cfg.field_name[ ndx ], stdout );
			(void) fputc( field_separator, stdout );
		}

		(void) fputs( cfg.field_name[ ndx ], stdout );
		(void) fputc( '\n', stdout );
	}

	dfile = dfile_read_open( &cfg, (dfile_bind_t *)0, (unsigned short)0, tag_tbl, tag_tbl_cnt, blocks_per_buffer_cnt, buffer_cnt );

	if ( dfile == (dfile_t *)0 ) {
		RETURN_INT( 20 );
	}

	if ( filter_file == ( const char *)0 ) {
		filter = (void *)0;
	} else {
		if ( where_compile_file( &filter, err_msg, sizeof( err_msg ), filter_file, dfile ) != WHERE_NOERR ) {
			(void) fputs( "where_compile_file() failed [", stderr );
			(void) fputs( filter_file, stderr );
			(void) fputs( "]: [", stderr );
			(void) fputs( err_msg, stderr );
			(void) fputs( "].\n", stderr );
			RETURN_INT( 25 );
		}
	}

	bind_tbl = dfile->bind;

	while ( dfile_read( dfile ) == 0 ) {
		if ( filter != (void *)0 ) {
			if ( where_condition( &where_result, err_msg, sizeof( err_msg ), filter ) != WHERE_NOERR ) {
				(void) fputs( "where_condition() failed [", stderr );
				(void) fputs( err_msg, stderr );
				(void) fputs( "].\n", stderr );
				RETURN_INT( 26 );
			}
			if ( where_result != Where_result_true ) {
				continue;
			}
		}
		/*
		** Print field values.
		*/
		for ( ndx = 0; ndx < dfile->bind_cnt - 1; ++ndx ) {
			(void) fputs( *bind_tbl[ ndx ].field_buffer, stdout );
			(void) fputc( field_separator, stdout );
		}

		(void) fputs( *bind_tbl[ ndx ].field_buffer, stdout );
		(void) fputc( '\n', stdout );
	}

	if ( dfile->error != Dfile_all_data_processed ) {
		fput_src_code( __FILE__, __LINE__, stderr );
		(void) fputs( "Failed to read all data.\n", stderr );
		RETURN_INT( 30 );
	}

	(void) dfile_read_close( dfile );

	RETURN_INT( 0 );
}
