/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <sys/types.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "sexpr.h"
#include "dfile_exec.h"

/*
** This function assigns information from control structure.
*/
int assign_setenv( char ***ret_env_var, unsigned short *ret_env_var_cnt, sexpr_t *field, unsigned short tuple_cnt )
{
	char	*var_name, *var_value, **env_var, **new;
	unsigned short	env_var_cnt;
	int	ret, cnt;
	sexpr_t	*setenv;
	size_t	alloc_size;

	assert( ret_env_var != (char ***)0 );
	assert( ret_env_var_cnt != (unsigned short *)0 );

	DEBUG_FUNC_START;

	env_var = *ret_env_var;
	env_var_cnt = *ret_env_var_cnt;

	while ( field != (sexpr_t *)0 ) {
		if ( SEXPR_CAR_TYPE( field ) != list_sexpr ) {
			CONTROL_SYNTAX_ERROR( "expected a list", tuple_cnt );
			RETURN_INT( -1 );
		}

		setenv = SEXPR_CAR_LIST( field );

		ret = assign_string( &var_name, setenv, "variable name", tuple_cnt );
		if ( ret == -1 ) {
			RETURN_INT( -1 );
		}

		assert( SEXPR_CDR_TYPE( setenv ) == list_sexpr );
		setenv = SEXPR_CDR_LIST( setenv );
		if ( setenv == (sexpr_t *)0 ) {
			CONTROL_SYNTAX_ERROR( "expected a string", tuple_cnt );
			RETURN_INT( -1 );
		}

		ret = assign_string( &var_value, setenv, "variable value", tuple_cnt );
		if ( ret == -1 ) {
			RETURN_INT( -1 );
		}

		alloc_size = sizeof( char * ) * ( env_var_cnt + (unsigned short)1 );
		new = (char **)realloc( env_var, alloc_size );
		if ( new == (char **)0 ) {
			UNIX_ERROR( "realloc() failed" );
			RETURN_INT( -1 );
		}

		env_var = new;

		alloc_size = strlen( var_name ) + strlen( var_value ) + (size_t)2;
		new = &new[ env_var_cnt ];

		*new = (char *)malloc( alloc_size );
		if ( *new == (char *)0 ) {
			UNIX_ERROR( "malloc() failed" );
			RETURN_INT( -1 );
		}

		cnt = snprintf( *new, alloc_size, "%s=%s", var_name, var_value );
		if ( cnt != ( alloc_size - 1 ) ) {
			FPUT_SRC_CODE( stderr );
			(void) fputs( "failed to create environment string [", stderr );
			(void) fputs( "var_name", stderr );
			(void) fputs( "=", stderr );
			(void) fputs( "var_value", stderr );
			(void) fputs( "].\n", stderr );
			RETURN_INT( -1 );
		}

		++env_var_cnt;
		assert( SEXPR_CDR_TYPE( field ) == list_sexpr );
		field = SEXPR_CDR_LIST( field );
	}


	*ret_env_var = env_var;
	*ret_env_var_cnt = env_var_cnt;

	RETURN_INT( 0 );
}
