/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */


#include <limits.h>

typedef struct {
	const char	*step_name;
	const char	*partition;
	int		exit_code;
} completed_t;

typedef struct proc_s	proc_t;

struct proc_s {
	pid_t	pid;
	char	**exec_args;
	char	**env_var;
	int	status;
	int	signal_value;
	int	stdout_fd;
	int	stderr_fd;
	const char	*partition;
	int	partition_ndx;
	proc_t	*prev;
	proc_t	*next;
};

typedef struct {
	char	*step_name;
	char	*stdin_fname;
	char	*stdout_fname;
	char	*stderr_fname;
	char	*partition;
	unsigned short	max_processes;
	char	**exec_arg;
	unsigned short	exec_arg_cnt;
	char	**env_var;
	unsigned short	env_var_cnt;
	unsigned char	successful_exit[UCHAR_MAX+1];
} step_t;

int get_args( int, char * const [], const char **, const char ** );
int parse_exec_args( const char *, char *** );
proc_t *alloc_proc_tbl( unsigned short );
int assign_fname( char **, const char *, unsigned short, unsigned short, const char * );

int start_procs( unsigned short *, proc_t *, void **proc_tree, char **, unsigned short, unsigned short, unsigned short, step_t *, int, const char * );

pid_t exec_proc( int *, int *, char * const *, char **, const char *, const char *, const char * );
int proc_cmp( const void *, const void * );
int wait_proc( unsigned short *, void **, int *, proc_t **, int, const char *, const char * );
int replace_arg_flags( char **, unsigned short, const char * );
int assign_input_fname( const char ***, unsigned short *, const char * );
int get_divvy_text( char ***, unsigned short *, const char * );
int load_recovery_log( proc_t *, unsigned short *, unsigned short, unsigned short, const char * );
int write_recovery_log( proc_t *, unsigned short, unsigned short, const char * );
int assign_exec_args( char ***, char ***, char **, unsigned short, char **, unsigned short, const char *, unsigned short );
int set_proc_list( proc_t **, unsigned short *, proc_t *, completed_t *, unsigned long, char **, unsigned short, const char *, const unsigned char * );
int get_cpu_semid( const char * );
int request_proc_resource( int *, unsigned short, int );
int release_allocated_procs( unsigned short, int );
void write_system_usage( const char *, time_t, time_t, time_t );
int substitute_tokens( char **, const char *, const char * );


int assign_step_attrib( step_t *, sexpr_t *, unsigned short );
int assign_step( step_t **, unsigned short *, sexpr_t *, unsigned short );
int assign_job( const char **, step_t **, unsigned short *, const char * );
int assign_exec( char ***, unsigned short *, sexpr_t *, unsigned short );

int assign_string( char **, sexpr_t *, const char *, unsigned short );
void print_job( const char *, step_t *, unsigned short );

int copy_exec_args( char ***, char **, unsigned short );
int process_step( step_t *, completed_t *, unsigned long, int, const char * );
int open_log_file( const char * );
int write_log_record( int, const char *, const char *, const char *, pid_t, const char, int *, int * );
void control_syntax_error( const char *, const char *, int, unsigned short );
void print_time( const char *, time_t );
int assign_exit_values( unsigned char *, sexpr_t *, unsigned short );
int load_completed( completed_t **, unsigned long *, const char *, const char * );
int completed_cmp( const void *, const void * );
int completed_status( int *, int *, completed_t *, unsigned long, const char *, const char *, const unsigned char * );
int assign_setenv( char ***, unsigned short *, sexpr_t *, unsigned short );

#define CONTROL_SYNTAX_ERROR( m, t )    control_syntax_error( m, __FILE__, __LINE__, t )
