/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "where.h"
#include "dfile_utility.h"
#include "sexpr.h"
#include "dfile_join.h"


/*
** This function compiles record filters.
*/
int compile_io_filters( void **input_filter, void **output_filter, sexpr_t *input_filter_sexpr, sexpr_t *output_filter_sexpr, dfile_t *input_dfile, dfile_t *output_dfile )
{
	char	err_msg[ 256 ];

	assert( input_filter != (void **)0 );
	assert( output_filter != (void **)0 );
	/*
	** When no filtering occurs, filter file names will be null.
	*/
	assert( input_dfile != (dfile_t *)0 );
	assert( output_dfile != (dfile_t *)0 );

	DEBUG_FUNC_START;

	if ( input_filter_sexpr == (sexpr_t *)0 ) {
		*input_filter = (void *)0;
	} else {
		if ( where_compile_sexpr( input_filter, err_msg, sizeof( err_msg ), input_filter_sexpr, input_dfile ) != WHERE_NOERR ) {
			FPUT_SRC_CODE( stderr );
			(void) fputs( "where_compile_sexpr() failed\n\t+ [", stderr );
			(void) fputs( err_msg, stderr );
			(void) fputs( "].\n", stderr );
			RETURN_INT( -1 );
		}
	}

	if ( output_filter_sexpr == (sexpr_t *)0 ) {
		*output_filter = (void *)0;
	} else {
		if ( where_compile_sexpr( output_filter, err_msg, sizeof( err_msg ), output_filter_sexpr, output_dfile ) != WHERE_NOERR ) {
			FPUT_SRC_CODE( stderr );
			(void) fputs( "where_compile_sexpr() failed\n\t+ [", stderr );
			(void) fputs( err_msg, stderr );
			(void) fputs( "].\n", stderr );
			RETURN_INT( -1 );
		}
	}

	RETURN_INT( 0 );
}
