/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "sexpr.h"
#include "dfile_utility.h"
#include "dfile_join.h"


/*
** This function assigns information from control structure.
*/
int level1_syntax( input_ctl_t *input_ctl, join_ctl_t **join_ctl_tbl, unsigned short *join_ctl_tbl_cnt, output_ctl_t *output_ctl, sexpr_t *level1, unsigned short tuple_cnt, dfile_tag_t *dfile_tag_tbl, unsigned short dfile_tag_tbl_cnt )
{
	char	*str;
	int	ret;

	/*
	** processed flags initialized to false.
	*/
	static int	input_processed_flag = 0;
	static int	join_processed_flag = 0;
	static int	output_processed_flag = 0;

	assert( input_ctl != (input_ctl_t *)0 );
	assert( join_ctl_tbl != (join_ctl_t **)0 );
	assert( join_ctl_tbl_cnt != (unsigned short *)0 );
	assert( level1 != (sexpr_t *)0 );

	DEBUG_FUNC_START;

	if ( SEXPR_CAR_TYPE( level1 ) != string_sexpr ) {
		control_syntax_error( "expected a string", __FILE__, __LINE__, tuple_cnt );
		RETURN_INT( -1 );
	}

	str = SEXPR_CAR_STRING( level1 );

	assert( SEXPR_CDR_TYPE( level1 ) == list_sexpr );

	if ( SEXPR_CDR_LIST( level1 ) == (sexpr_t *)0 ) {
		control_syntax_error( "null list", __FILE__, __LINE__, tuple_cnt );
		RETURN_INT( -1 );
	}


	if ( strcasecmp( str, "input" ) == 0 ) {
		if ( input_processed_flag ) {
			fput_src_code( __FILE__, __LINE__, stderr );
			(void) fputs( "More than one INPUT configuration found.\n", stderr ); 
			RETURN_INT( -1 );
		}

		ret = assign_input( input_ctl, SEXPR_CDR_LIST( level1 ), tuple_cnt, dfile_tag_tbl, dfile_tag_tbl_cnt );

		/*
		** Set input_processed_flag to true.
		*/
		input_processed_flag = 1;
		RETURN_INT( ret );
	}

	if ( strcasecmp( str, "join" ) == 0 ) {
		if ( join_processed_flag ) {
			fput_src_code( __FILE__, __LINE__, stderr );
			(void) fputs( "More than one JOIN configuration found.\n", stderr ); 
			RETURN_INT( -1 );
		}

		ret = assign_join( join_ctl_tbl, join_ctl_tbl_cnt, SEXPR_CDR_LIST( level1 ), tuple_cnt, dfile_tag_tbl, dfile_tag_tbl_cnt );

		/*
		** Set input_processed_flag to true.
		*/
		join_processed_flag = 1;

		RETURN_INT( ret );
	}

	if ( strcasecmp( str, "output" ) == 0 ) {
		if ( output_processed_flag ) {
			fput_src_code( __FILE__, __LINE__, stderr );
			(void) fputs( "More than one OUTPUT configuration found.\n", stderr ); 
			RETURN_INT( -1 );
		}

		ret = assign_output( output_ctl, SEXPR_CDR_LIST( level1 ), tuple_cnt, dfile_tag_tbl, dfile_tag_tbl_cnt );

		/*
		** Set output_processed_flag to true.
		*/
		output_processed_flag = 1;

		RETURN_INT( ret );
	}

	control_syntax_error( "unknown section", __FILE__, __LINE__, tuple_cnt );

	RETURN_INT( -1 );
}
