/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_dynamic.h"
#include "dfile_utility.h"
#include "sexpr.h"
#include "where.h"
#include "dfile_join.h"

/*
** This function does preparation work for join dfiles before actual join
** operation starts.
*/
int prepare_joins( join_ctl_t *join_tbl, unsigned short join_tbl_cnt, dfile_t *input_dfile, dfile_t *output_dfile )
{
	static const char	join_str[] = "join";
	static const char	input_str[] = "input";
	static const char	output_str[] = "output";
	char	err_msg[ 256 ];
	dfile_bind_t	*join_bind, bind_key, **bind_entry, **join_sorted_bind;
	dfile_bind_t	*lookup_bind;
	unsigned short	join_bind_cnt;

	assert( join_tbl != (join_ctl_t *)0 );
	assert( input_dfile != (dfile_t *)0 );
	assert( output_dfile != (dfile_t *)0 );

	DEBUG_FUNC_START;

	for ( ; join_tbl_cnt > (unsigned short)0; --join_tbl_cnt ) {
		if ( join_tbl->ipc_key == (const char *)0 ) {
			if ( open_input_dfile( &join_tbl->dfile, join_tbl->dfile_name, join_tbl->tag, join_tbl->tag_cnt, join_tbl->blocks_per_buffer_cnt, join_tbl->buffer_cnt ) == -1 ) {
				RETURN_INT( -1 );
			}
			join_bind = join_tbl->dfile->bind;
			join_bind_cnt = join_tbl->dfile->bind_cnt;
			join_sorted_bind = join_tbl->dfile->sorted_bind;

			if ( join_tbl->record_filter == (sexpr_t *)0 ) {
				join_tbl->where = (void *)0;
			} else {
				if ( where_compile_sexpr( &join_tbl->where, err_msg, sizeof( err_msg ), (void *)join_tbl->record_filter, join_tbl->dfile ) != WHERE_NOERR ) {
					FPUT_SRC_CODE( stderr );
					(void) fputs( "where_compile_sexpr() failed for joining dfile [", stderr );
					(void) fputs( join_tbl->dfile_name, stderr );
					(void) fputs( "]\n\t+ [", stderr );
					(void) fputs( err_msg, stderr );
					(void) fputs( "].\n", stderr );
					RETURN_INT( -1 );
				}
			}

			if ( assign_field_bind( &join_tbl->join_key_tbl, join_tbl->key_field_tbl, join_tbl->key_field_tbl_cnt, join_sorted_bind, join_bind_cnt ) == -1 ) {
				RETURN_INT( -1 );
			}

		} else {
			if ( create_shm_bind( &join_bind, &join_bind_cnt, &join_sorted_bind, join_tbl->dfile_name ) == -1 ) {
				RETURN_INT( -1 );
			}

			join_tbl->shm.bind = join_bind;
			join_tbl->shm.field_cnt = join_bind_cnt;
		}

		if ( assign_field_offset( &join_tbl->join_key_ndx_tbl, join_tbl->key_field_tbl, join_tbl->key_field_tbl_cnt, join_bind, join_sorted_bind, join_bind_cnt ) == -1 ) {
			RETURN_INT( -1 );
		}

		if ( map_fields( &join_tbl->input_key_tbl, join_tbl->key_field_tbl, join_tbl->key_field_tbl_cnt, input_dfile->sorted_bind, input_dfile->bind_cnt, join_tbl->map_field_tbl, join_tbl->map_field_tbl_cnt, join_str, input_str ) == -1 ) {
			RETURN_INT( -1 );
		}

		if ( join_tbl->copy_field_tbl_cnt > (unsigned short)0 ) {
			if ( assign_field_bind( &join_tbl->join_field_tbl, join_tbl->copy_field_tbl, join_tbl->copy_field_tbl_cnt, join_sorted_bind, join_bind_cnt ) == -1 ) {
				RETURN_INT( -1 );
			}
			if ( assign_field_offset( &join_tbl->join_field_ndx_tbl, join_tbl->copy_field_tbl, join_tbl->copy_field_tbl_cnt, join_bind, join_sorted_bind, join_bind_cnt ) == -1 ) {
				RETURN_INT( -1 );
			}

			if ( map_fields( &join_tbl->output_field_tbl, join_tbl->copy_field_tbl, join_tbl->copy_field_tbl_cnt, output_dfile->sorted_bind, output_dfile->bind_cnt, join_tbl->map_field_tbl, join_tbl->map_field_tbl_cnt, join_str, output_str ) == -1 ) {
				RETURN_INT( -1 );
			}
		}

		if ( join_tbl->status_field == (const char *)0 ) {
			join_tbl->outer_join_status_field = (dfile_bind_t *)0;
		} else {
			bind_key.field_name = join_tbl->status_field;
			lookup_bind = &bind_key;
			bind_entry = (dfile_bind_t **)bsearch( (void *)&lookup_bind, output_dfile->sorted_bind, output_dfile->bind_cnt, sizeof( dfile_bind_t * ), dfile_bind_field_name_cmp );

			if ( bind_entry == (dfile_bind_t **)0 ) {
				FPUT_SRC_CODE( stderr );
				(void) fputs( "Outer join status field [", stderr );
				(void) fputs( join_tbl->status_field, stderr );
				(void) fputs( "] was not in output layout.\n", stderr );
				RETURN_INT( -1 );
			}
			join_tbl->outer_join_status_field = *bind_entry;
		}

		if ( join_tbl->ipc_key != (const char *)0 ) {
			if ( attach_shared_memory( &join_tbl->shm, join_tbl->ipc_key, join_tbl->join_key_ndx_tbl, join_tbl->key_field_tbl_cnt ) == -1 ) {
				RETURN_INT( -1 );
			}
		}

		++join_tbl;
	}

	RETURN_INT( 0 );
}
