/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"
#include "dfile_partition.h"


/*
** This function combines dfile tags into one array.
*/
int assign_output_tags( dfile_tag_t **tag_tbl, unsigned short *tag_tbl_cnt, dfile_tag_t *output_tag_tbl, unsigned short output_tag_tbl_cnt, dfile_tag_t *common_tag_tbl, unsigned short common_tag_tbl_cnt, char *output_partition_tag )
{
	dfile_tag_t	*new;
	unsigned short	new_cnt;

	assert( tag_tbl != (dfile_tag_t **)0 );

	DEBUG_FUNC_START;

	if ( output_partition_tag != (char *)0 ) {
		new = (dfile_tag_t *)malloc( sizeof( dfile_tag_t ) );
		if ( new == (dfile_tag_t *)0 ) {
			unix_error( "malloc() failed", __FILE__, __LINE__ );
			RETURN_INT( -1 );
		}

		new->tag = output_partition_tag;
		new->tag_value = output_partition_tag;
		new_cnt = (unsigned short)1;
	}

	if ( append_tag( &new, &new_cnt, output_tag_tbl, output_tag_tbl_cnt ) == -1 ) {
		RETURN_INT( -1 );
	}

	if ( append_tag( &new, &new_cnt, common_tag_tbl, common_tag_tbl_cnt ) == -1 ) {
		RETURN_INT( -1 );
	}

	*tag_tbl = new;
	*tag_tbl_cnt = new_cnt;

	RETURN_INT( 0 );
}
