/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <limits.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"
#include "sexpr.h"
#include "dfile_sort.h"


/*
** This function assigns information from control structure.
*/
int assign_ushort( unsigned short *result, sexpr_t *sexpr, unsigned short tuple_cnt )
{
	unsigned long	converted_value;
	char	*ptr;

	assert( result != (unsigned short *)0 );
	assert( sexpr != (sexpr_t *)0 );

	DEBUG_FUNC_START;

	if ( SEXPR_CAR_TYPE( sexpr ) != string_sexpr ) {
		CONTROL_SYNTAX_ERROR( "expected a string", tuple_cnt );
		RETURN_INT( -1 );
	}

	ptr = SEXPR_CAR_STRING( sexpr );

	converted_value = strtoul( SEXPR_CAR_STRING( sexpr ), &ptr, 10 );

	if ( ptr == SEXPR_CAR_STRING( sexpr ) || *ptr != (char )0 || converted_value > USHRT_MAX ) {
		CONTROL_SYNTAX_ERROR( "expected ushort value", tuple_cnt );
		RETURN_INT( -1 );
	}

	*result = converted_value;

	if ( Debug ) {
		(void) fprintf( stderr, "ushort value [%hu]\n", *result );
	}

	RETURN_INT( 0 );
}
