/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <limits.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"
#include "sexpr.h"
#include "dfile_sort.h"


/*
** This function writes sorted records. It is used when sorted data
** does not need to be merged with other files.
*/
int write_sorted_records( dfile_t *dfile, field_t **record, unsigned long record_cnt )
{
	dfile_bind_t	*bind;
	unsigned short	bind_cnt;

	assert( dfile != (dfile_t *)0 );

	DEBUG_FUNC_START;

	bind = dfile->bind;
	bind_cnt = dfile->bind_cnt;

	for ( ; record_cnt > 0UL; --record_cnt ) {
		copy_record_to_bind( bind, bind_cnt, *record );
		if ( dfile_write( dfile ) == -1 ) {
			RETURN_INT( -1 );
		}
		++record;
	}

	RETURN_INT( 0 );
}
