/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include <regex.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_dynamic.h"
#include "dfile_utility.h"
#include "dfile_transform.h"


/*
** This program transforms field values.
*/
int main( int argc, char **argv )
{
	const char	*input_dfile_name, *output_dfile_name;
	const char	*input_filter_file_name, *output_filter_file_name;
	const char	*control_file_name;
	dfile_t	*output_dfile, *input_dfile;
	int	thread_input_flag, thread_output_flag;
	dfile_tag_t	*dfile_tag_tbl;
	unsigned short	dfile_tag_tbl_cnt, *field_ndx_tbl, trnsfrm_cnt;
	void	*input_filter, *output_filter;
	trnsfrm_t	*trnsfrm;

	if ( get_args( argc, argv, &input_dfile_name, &output_dfile_name, &thread_input_flag, &thread_output_flag, &dfile_tag_tbl, &dfile_tag_tbl_cnt, &input_filter_file_name, &output_filter_file_name, &control_file_name ) == -1 ) {
		return 5;
	}

	DEBUG_FUNC_START;

	if ( load_control_file( &trnsfrm, &trnsfrm_cnt, control_file_name ) == -1 ) {
		RETURN_INT( 10 );
	}

	if ( trnsfrm_cnt == (unsigned short)0 ) {
		FPUT_SRC_CODE( stderr );
		(void) fputs( "Control file contained no entries to process.\n", stderr );
		RETURN_INT( 15 );
	}

	if ( open_dfile( &input_dfile, input_dfile_name, dfile_tag_tbl, dfile_tag_tbl_cnt, thread_input_flag, 'r' ) == -1 ) {
		RETURN_INT( 20 );
	}

	if ( open_dfile( &output_dfile, output_dfile_name, dfile_tag_tbl, dfile_tag_tbl_cnt, thread_output_flag, 'w' ) == -1 ) {
		RETURN_INT( 25 );
	}

	if ( map_dfile_field_names( &field_ndx_tbl, output_dfile->bind, output_dfile->bind_cnt, input_dfile->bind, input_dfile->sorted_bind, input_dfile->bind_cnt ) == -1 ) {
		RETURN_INT( 30 );
	}

	if ( compile_filters( &input_filter, &output_filter, (char *)input_filter_file_name, (char *)output_filter_file_name, input_dfile, output_dfile ) == -1 ) {
		RETURN_INT( 40 );
	}


	if ( assign_bind( trnsfrm, trnsfrm_cnt, input_dfile->sorted_bind, input_dfile->bind_cnt, output_dfile->sorted_bind, output_dfile->bind_cnt ) == -1 ) {
		RETURN_INT( 45 );
	}

	if ( process_file( trnsfrm, trnsfrm_cnt, output_dfile, input_dfile, field_ndx_tbl, input_filter, output_filter ) == -1 ) {
		RETURN_INT( 50 );
	}

#if 0
	(void) dfile_read_close( input_dfile );
#endif

	if ( dfile_write_close( output_dfile ) == -1 ) {
		RETURN_INT( 55 );
	}

	RETURN_INT( 0 );
}
