/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <regex.h>
#include <stdio.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_dynamic.h"
#include "where.h"
#include "dfile_utility.h"
#include "dfile_transform.h"


/*
** This function reads the input file and writes the record to an output file.
*/
int process_file( trnsfrm_t *trnsfrm, unsigned short trnsfrm_cnt, dfile_t *output_dfile, dfile_t *input_dfile, unsigned short *field_ndx_tbl, void *input_filter, void *output_filter )
{
	unsigned short	input_bind_cnt, output_bind_cnt;
	where_result_t	where_result;
	char	err_msg[ 256 ];
	dfile_bind_t	*input_bind, *output_bind;

	assert( trnsfrm != (trnsfrm_t *)0 );
	assert( output_dfile != (dfile_t *)0 );
	assert( input_dfile != (dfile_t *)0 );
	assert( field_ndx_tbl != (unsigned short *)0 );
	/*
	** When filters are not used, pointers will be null.
	*/

	DEBUG_FUNC_START;

	input_bind = input_dfile->bind;
	input_bind_cnt = input_dfile->bind_cnt;
	output_bind = output_dfile->bind;
	output_bind_cnt = output_dfile->bind_cnt;

	while ( dfile_read( input_dfile ) == 0 ) {
		if ( input_filter != (void *)0 ) {
			if ( where_condition( &where_result, err_msg, sizeof( err_msg ), input_filter ) != WHERE_NOERR ) {
				FPUT_SRC_CODE( stderr );
				(void) fputs( "input where_condition() failed [", stderr );
				(void) fputs( err_msg, stderr );
				(void) fputs( "].\n", stderr );
				RETURN_INT( -1 );
			}
			if ( where_result == Where_result_false ) {
				/*
				** Skip record.
				*/
				continue;
			}
		}

		copy_record_to_bind( output_bind, input_bind, field_ndx_tbl, output_bind_cnt );

		if ( process_trnsfrm( trnsfrm, trnsfrm_cnt ) == -1 ) {
			RETURN_INT( -1 );
		}

		if ( output_record( output_dfile, output_filter ) == -1 ) {
			RETURN_INT( -1 );
		}
	}

	if ( input_dfile->error != Dfile_all_data_processed ) {
		FPUT_SRC_CODE( stderr );
		(void) fputs( "Failed to read all data.\n", stderr );
		RETURN_INT( -1 );
	}

	RETURN_INT( 0 );
}
