/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <limits.h>
#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"
#include "dfile_unique.h"


/*
** This function parses command line key fields.
*/
int parse_unique_key( char ***key_tbl, unsigned short *key_tbl_cnt, char *unique_key )
{
	unsigned long	list_cnt;
	char	**key;

	assert( key_tbl != (char ***)0 );
	assert( key_tbl_cnt != (unsigned short *)0 );
	assert( unique_key != (char *)0 );

	DEBUG_FUNC_START;

	/*
	** Parse key field names from command line argument.
	*/
	list_cnt = 0UL;
	key = (char **)0;
	if ( parse_list( &key, &list_cnt, unique_key, ',' ) == -1 ) {
		RETURN_INT( -1 );
	}

	if ( list_cnt == 0 ) {
		FPUT_SRC_CODE( stderr );
		(void) fputs( "must specify fields for unique key.\n", stderr );
		RETURN_INT( -1 );
	}

	if ( list_cnt > (unsigned long)USHRT_MAX ) {
		FPUT_SRC_CODE( stderr );
		(void) fputs( "exceeded maximum number of fields for unique key.\n", stderr );
		RETURN_INT( -1 );
	}

	*key_tbl = key;
	*key_tbl_cnt = (unsigned short)list_cnt;

	RETURN_INT( 0 );
}
