##
## This is an example job stream used by utility dfile_exec.
##
( job emp
	( step 100.mkdir
		( exec mkdir -p
			data/employee.110
			data/address.110
			data/phone.110
			data/employee.120
			data/address.130
			data/phone.140
			data/emp.150
			data/emp.160
			data/emp.170
			data/emp.180
			tmp/110
			tmp/120
			tmp/130
			tmp/140
			tmp/150
			tmp/160
			tmp/170
			tmp/180 )
		( stdout tmp/100.out )
		( stderr tmp/100.err ) )

	( step 110.dfile_partition
		( exec dfile_partition -f emp_nbr -i %s -o %s.110 -p %p -h 7 )
		( partition ctl/emp_nbr_files.txt )
		( max-processes 2 )
		( stdout tmp/110/%s.out )
		( stderr tmp/110/%s.err ) )

	( step 120.dfile_sort
		( exec dfile_sort
			-i employee.110
			-o employee.120
			-k emp_nbr,eff_dt
			-t%p=%s )
		( partition 7 )
		( max-processes 3 )
		( stdout tmp/120/%s.out )
		( stderr tmp/120/%s.err ) )

	( step 130.dfile_sort
		( exec dfile_sort
			-i address.110
			-o address.130
			-k emp_nbr,eff_dt
			-t%p=%s )
		( partition 7 )
		( max-processes 3 )
		( stdout tmp/130/%s.out )
		( stderr tmp/130/%s.err ) )

	( step 140.dfile_sort
		( exec dfile_sort
			-i phone.110
			-o phone.140
			-k emp_nbr,eff_dt
			-t%p=%s )
		( partition 7 )
		( max-processes 3 )
		( stdout tmp/140/%s.out )
		( stderr tmp/140/%s.err ) )

	( step 150.dfile_join
		( exec dfile_join -c ctl/emp_join.ctl -t%p=%s )
		( partition 7 )
		( stdout tmp/150/%s.out )
		( stderr tmp/150/%s.err ) )

	( step 160.dfile_cache_create
		( exec dfile_cache_create -a 0x333 -i zip_code )
		( stdout tmp/160.out )
		( stderr tmp/160.err ) )

	( step 180.dfile_join
		( exec dfile_join -d -c ctl/emp_join2.ctl -t%p=%s )
		( partition 7 )
		( stdout tmp/180/%s.out )
		( stderr tmp/180/%s.err ) )

	( step 185.ipcrm
		( exec ipcrm -M 0x333 )
		( stdout tmp/185.out )
		( stderr tmp/185.err ) )

	( step 190.dfile_transform
		( exec dfile_transform
			-c ctl/emp_transform.ctl
			-i emp.180
			-o emp.190
			-t%p=%s )
		( partition 7 )
		( stdout tmp/190/%s.out )
		( stderr tmp/190/%s.err ) ) )
