/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"


/*
** This function joins pgm_var and cfg_bind arrays using field_name values.
** Variable pgm_var is expected to contain the application's C variables, and
** cfg_bind is expected to contain fields for record definition.
** Address of program host variables are copied from pgm_var to corresponding
** entries in cfg_bind.
*/

int _dfile_bind( dfile_bind_t **cfg_bind, unsigned short cfg_bind_cnt, const dfile_bind_t *pgm_var, unsigned short pgm_var_cnt )
{
	static const char	bind_err_msg1[] = "Failed to match program bind variable [";
	static const char	bind_err_msg2[] = "] with record layout.\n";
	int	bind_error_flag;
	dfile_bind_t	**search_result;

	assert( cfg_bind != (dfile_bind_t **)0 );
	assert( cfg_bind_cnt > (unsigned short)0 );

	DEBUG_FUNC_START;

	/*
	** Set bind_error_flag to false.
	*/
	bind_error_flag = 0;

	for ( ; pgm_var_cnt > (unsigned short)0; ++pgm_var, --pgm_var_cnt ) {
		search_result = (dfile_bind_t **)bsearch( (void *)&pgm_var, cfg_bind, cfg_bind_cnt, sizeof( dfile_bind_t * ), dfile_bind_field_name_cmp );

		if ( search_result == (dfile_bind_t **)0 ) {
			/*
			** Set bind_error_flag to true.
			*/
			bind_error_flag = 1;

			FPUT_SRC_CODE( stderr );
			(void) fputs( bind_err_msg1, stderr );
			(void) fputs( pgm_var->field_name, stderr );
			(void) fputs( bind_err_msg2, stderr );
			continue;
		}

		if ( Debug ) {
			(void) fprintf( stderr, "[%s], %p %p\n", pgm_var->field_name, pgm_var->field_buffer, pgm_var->field_length );
		}

		( *search_result )->field_buffer = pgm_var->field_buffer;
		( *search_result )->field_length = pgm_var->field_length;
	}

	if ( bind_error_flag ) {
		RETURN_INT( -1 );
	}

	RETURN_INT( 0 );
}
