/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"


/*
** This function finds the beginning of the last record fragment in buffer.
** It is only used for files that use the escaped record format.
*/

int _dfile_escaped_overflow( const char **buf_ptr_end, const char *buffer, size_t buffer_len, dfile_rec_t rec )
{
	register const char	*ptr;

	assert( buf_ptr_end != (const char **)0 );
	assert( buffer != (const char *)0 );
	assert( buffer_len > (size_t)0 );

	DEBUG_FUNC_START;

	*buf_ptr_end = (const char *)0;
	ptr = &buffer[ buffer_len ];

	while ( --ptr > buffer ) {
		if ( *ptr == rec.record_separator ) {
			if ( ptr[ -1 ] != rec.separator_escape ) {
				/*
				** End of record.
				*/
				*buf_ptr_end = &ptr[ 1 ];
				RETURN_INT( 0 );
			}
		}
	}

	assert( ptr == buffer );

	if ( *ptr == rec.record_separator ) {
		*buf_ptr_end = &ptr[ 1 ];
		RETURN_INT( 0 );
	}

	RETURN_INT( -1 );
}
