/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"


/*
** This function calls parsing routines. If end of buffer is reach, buffer
** is refilled and parsing routine is called finish parsing the record.
*/

int _dfile_process_read( dfile_t *dfile )
{
	dfile_parse_t	parse;
	dfile_buffer_t	*buffer;

	assert( dfile != (dfile_t *)0 );

	DEBUG_FUNC_START;

	buffer = dfile->application_buffer;

	assert( buffer != (dfile_buffer_t *)0 );

	for ( ;; ) {
		if ( buffer->buf_ptr >= buffer->buf_ptr_end ) {
			/*
			** Single buffer is exhausted.
			*/
			if ( ( *dfile->io_buffer_func )( dfile ) == -1 ) {
				if ( dfile->error == Dfile_end_of_file ) {
					buffer->processing_complete_flag = 'Y';
					_dfile_read_eof_processing( dfile, buffer );
				}
				RETURN_INT( -1 );
			}
		}

		if ( dfile->record_type == Dfile_delimited ) {
			parse = _dfile_get_record( dfile );
		} else {
			assert( dfile->record_type == Dfile_variable_length );

			parse = _dfile_get_var_record( dfile );
		}

		switch ( parse ) {
		case Dfile_parsed_record:
			RETURN_INT( 0 );

		case Dfile_parse_failed:
			break;

		case Dfile_fatal_parse_error:
			RETURN_INT( -1 );
		default:
			FPUT_SRC_CODE( stderr );
			(void) fputs( "Programming error--did not expect return value ", stderr );
			(void) fput_int( (int)parse, stderr );
			(void) fputs( " from get_record().\n", stderr );

			RETURN_INT( -1 );
		}
	}

	/*
	** Should never reach this point.
	*/
	abort();
}
