/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <zlib.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"


static void format_ulong( unsigned char *, unsigned long );

/*
** This function writes the GZIP trailer containing calculated 32-bit ASCII
** CRC and byte count.
*/

int _dfile_write_zipped_crc( dfile_t *dfile )
{
	unsigned char	buf[8];
	z_streamp	zstream;
	ssize_t	write_cnt;

	assert( dfile != (dfile_t *)0 );

	DEBUG_FUNC_START;

	zstream = (z_stream *)dfile->zstream;
	assert( zstream != (z_stream *)0 );

	format_ulong( buf, dfile->crc );
	format_ulong( &buf[ 4 ], dfile->file_char_cnt );

	if ( Debug ) {
		(void) fprintf( stderr, "Calculated CRC %lu\n", dfile->crc );
		(void) fprintf( stderr, "Calculated character count %lu\n", dfile->file_char_cnt );
	}

	write_cnt = write( dfile->open_descriptor, (void *)buf, sizeof( buf ) );
	if ( write_cnt < (ssize_t)0 ) {
		UNIX_ERROR( "write() failed" );
		dfile->error = Dfile_io_failed;
		RETURN_INT( -1 );
	}
	if ( write_cnt != sizeof( buf ) ) {
		(void) FPUT_SRC_CODE( stderr );
		(void) fputs( "write() did not output expected number bytes.\n", stderr );
		dfile->error = Dfile_io_failed;
		RETURN_INT( -1 );
	}

	RETURN_INT( 0 );
}

static void format_ulong( unsigned char *result, unsigned long x )
{
	result[ 0 ] = (unsigned char)( x & 0xff );
        x >>= 8;
	result[ 1 ] = (unsigned char)( x & 0xff );
        x >>= 8;
	result[ 2 ] = (unsigned char)( x & 0xff );
        x >>= 8;
	result[ 3 ] = (unsigned char)( x & 0xff );
}
