/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"


/*
** This function is used to compare dfile_bind_t structures by field_name.
*/

int dfile_bind_field_name_cmp( const void *x, const void *y )
{
	const dfile_bind_t	*lhs, *rhs;

	assert( x != (const void *)0 );
	assert( y != (const void *)0 );

	lhs = *(const dfile_bind_t **)x;
	rhs = *(const dfile_bind_t **)y;

	assert( lhs != (const dfile_bind_t *)0 );
	assert( rhs != (const dfile_bind_t *)0 );

	assert( ( (const dfile_bind_t *)x )->field_name != (const char *)0 );
	assert( ( (const dfile_bind_t *)y )->field_name != (const char *)0 );

	return strcasecmp( lhs->field_name, rhs->field_name );
}
