/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"


/*
** This function is called by user application to return one parsed record. It
** assumes dfile_read_open() was previously called.
*/

int dfile_read( dfile_t *dfile )
{
	int	ret;

	DEBUG_FUNC_START;

	if ( dfile == (dfile_t *)0 ) {
		FPUT_SRC_CODE( stderr );
		(void) fputs( "Function argument to dfile_read() cannot be null.\n", stderr );
		abort();
	}

	assert( dfile->bind_cnt > (unsigned short)0 );
	assert( dfile->bind != (dfile_bind_t *)0 );

	assert( dfile->file_name != (char *)0 );
#ifdef DFILE_THREAD
	assert( dfile->buffer_cnt > (unsigned short)0 );

	if ( dfile->buffer_cnt == (unsigned short)1 ) {
#endif
		/*
		** Single buffer processing.
		*/
		ret = _dfile_process_read( dfile );

#ifdef DFILE_THREAD
	} else {
		/*
		** Multi buffer processing.
		*/
		ret = _dfile_process_threaded_read( dfile );
	}
#endif

	if ( ret == -1 && dfile->error != Dfile_all_data_processed ) {
		FPUT_SRC_CODE( stderr );
		(void) fputs( "Read failure on data file [", stderr );
		(void) fputs( dfile->file_name, stderr );
		(void) fputs( "].\n", stderr );
	}

	RETURN_INT( ret );
}
