/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"


/*
** This function appends a group of DFile tags to another group of tags.
*/
int append_tag( dfile_tag_t **merge_tag, unsigned short *merge_tag_cnt, dfile_tag_t *cmd_line_tag, unsigned short cmd_line_tag_cnt )
{
	dfile_tag_t	*new;
	size_t	alloc_size, copy_size;

	DEBUG_FUNC_START;

	if ( cmd_line_tag_cnt == (unsigned short)0 ) {
		RETURN_INT( 0 );
	}

	alloc_size = (size_t)( *merge_tag_cnt + cmd_line_tag_cnt ) * sizeof( dfile_tag_t );
	new = realloc( *merge_tag, alloc_size );
	if ( new == (dfile_tag_t *)0 ) {
		UNIX_ERROR( "realloc() failed" );
		RETURN_INT( -1 );
	}

	copy_size = (size_t)cmd_line_tag_cnt * sizeof( dfile_tag_t );
	(void) memcpy( (void *)&new[ *merge_tag_cnt ], (void *)cmd_line_tag, copy_size );

	*merge_tag = new;
	*merge_tag_cnt += cmd_line_tag_cnt;

	RETURN_INT( 0 );
}
