/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include "tbox.h"
#include "sexpr.h"


/*
** This function formats sexpr_t structure to an ASCII string.
** Return value is zero for okay, -1 for UNIX error and positive value
** to represent particular s-expression failure.
*/

int _sexpr_format_string( char **dest, size_t *str_avail, const char *src )
{
	char	ch, *result;
	const char	*use_quote_char;

	assert( dest != (char **)0 );
	assert( str_avail != (size_t *)0 );
	assert( src != (const char *)0 );

	DEBUG_FUNC_START;

	result = *dest;

	use_quote_char = (const char *)strpbrk( src, " ()\t\n" );
	if ( use_quote_char != (const char *)0 ) {
		if ( *str_avail < (size_t)1 ) {
			RETURN_INT( SEXPR_NOSPACE );
		}
		*result = '"';
		++result;
		--*str_avail;
	}

	ch = *src;
	while ( ch != (char)0 ) {
		switch ( ch ) {
		case '\t':
		case '\n':
		case '"':
			if ( *str_avail < (size_t)1 ) {
				*dest = result;
				RETURN_INT( SEXPR_NOSPACE );
			}
			*result = '\\';
			++result;
			--*str_avail;
			break;
		}

		if ( *str_avail < (size_t)1 ) {
			*dest = result;
			RETURN_INT( SEXPR_NOSPACE );
		}

		switch ( ch ) {
		case '\t':
			*result = 't';
			break;
		case '\n':
			*result = 'n';
			break;
		default:
			*result = ch;
		}

		++result;
		--*str_avail;
		++src;
		ch = *src;
	}

	if ( use_quote_char != (const char *)0 ) {
		if ( *str_avail < (size_t)1 ) {
			*dest = result;
			RETURN_INT( SEXPR_NOSPACE );
		}
		*result = '"';
		++result;
		--*str_avail;
	}

	*result = ' ';
	++result;
	--*str_avail;

	*dest = result;

	RETURN_INT( 0 );
}
