/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <time.h>
#include "tbox.h"

/*
** This function returns the address of a string containing the current
** time in the format MM/DD/YY HH:MM:SS.
*/
const char *fmt_ctime( void )
{
	static char	fmt_str[40];
	struct tm	*ltime;
	time_t		gmt;
	int		year;

	(void) time( &gmt );
	if ( ( ltime = localtime( &gmt ) ) == (struct tm *) 0 ) {
		return (char *) 0;
	}

	/*
	** Make year Y2K compliant.
	*/
	year = ltime->tm_year % 100;

	(void) sprintf( fmt_str, "%02d/%02d/%02d %02d:%02d:%02d", ltime->tm_mon + 1, ltime->tm_mday, year, ltime->tm_hour, ltime->tm_min, ltime->tm_sec );

	return fmt_str;
}
