/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"


/*
** This function compares two strings having both lengths available.
*/

int strnncmp( const char *lhs_str, size_t lhs_len, const char *rhs_str, size_t rhs_len )
{
	size_t	cmp_len;
	int	result;

	assert( lhs_str != (const char *)0 );
	assert( rhs_str != (const char *)0 );

	if ( Debug ) {
		(void) fprintf( stderr, "%s( [%s], %u, [%s], %u )\n", __func__, lhs_str, lhs_len, rhs_str, rhs_len );
	}

	DEBUG_FUNC_START;

	/*
	** Choose shortest of both lengths.
	*/
	cmp_len = ( lhs_len > rhs_len ) ? rhs_len : lhs_len;

	/*
	** Include null byte in comparison.
	*/
	++cmp_len;

	result = memcmp( (void *)lhs_str, (void *)rhs_str, cmp_len );

	RETURN_INT( result );
}
