/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <ctype.h>
#include <assert.h>
#include "tbox.h"


/*
** This function converts a string to upper case.
*/

void strtoupper( register char *str )
{
	assert( str != (char *)0 );

	if ( Debug ) {
		(void) fprintf( stderr, "%s( %s )\n", __func__, str );
	}

	DEBUG_FUNC_START;

	while ( *str != (char)0 ) {
		*str = toupper( *str );
		++str;
	}

	if ( Debug ) {
		(void) fprintf( stderr, "result: [%s]\n", str );
	}

	RETURN_VOID;
}
