/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include "tbox.h"
#include "sexpr.h"
#include "dfile.h"
#include "where.h"
#include "_where.h"


/*
** This function creates portion of syntax tree for AND & OR expressions.
*/

int _where_multi_cond_syntax( multi_cond_t *multi_cond, sexpr_t *sexpr, dfile_t *dfile )
{
	int	ret;
	condition_t	*condition, *new;
	unsigned long	condition_cnt;
	size_t	alloc_size;

	assert( multi_cond != (multi_cond_t *)0 );
	assert( dfile != (dfile_t *)0 );

	DEBUG_FUNC_START;

	multi_cond->condition = (condition_t *)0;
	multi_cond->condition_cnt = 0UL;

	condition = (condition_t *)0;
	condition_cnt = 0UL;

	while ( sexpr != (sexpr_t *)0 ) {
		alloc_size = ( (size_t)condition_cnt + (size_t)1 ) * sizeof( condition_t );
		new = (condition_t *)realloc( (void *)condition, alloc_size );
		if ( new == (condition_t *)0 ) {
			UNIX_ERROR( "realloc() failed" );
			RETURN_INT( WHERE_UNIXERR );
		}

		condition = new;

		if ( SEXPR_CAR_TYPE( sexpr ) != list_sexpr ) {
			FPUT_SRC_CODE( stderr );
			(void) fputs( "Missing a condition expression.\n", stderr );
			RETURN_INT( WHERE_SYNTAX );
		}

		ret = _where_condition_syntax( &condition[ condition_cnt ], sexpr, dfile );
		if ( ret != WHERE_NOERR ) {
			RETURN_INT( ret );
		}

		++condition_cnt;

		sexpr = SEXPR_CDR_LIST( sexpr );
	}

	multi_cond->condition = condition;
	multi_cond->condition_cnt = condition_cnt;

	if ( Debug ) {
		(void) fprintf( stderr, "condition_cnt = %lu\n", condition_cnt );
	}

	RETURN_INT( WHERE_NOERR );
}
