/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_cache_create.h"


/*
** This fuction changes permission on shared memory segment to read only.
*/
int smtable_readonly( int segment )
{
	struct shmid_ds shm_settings;

	DEBUG_FUNC_START;

	if ( shmctl( segment, IPC_STAT, &shm_settings ) == -1 ) {
		UNIX_ERROR( "shmctl() failed" );
		RETURN_INT( -1 );
	}

	shm_settings.shm_perm.mode = 0440;

	if ( shmctl( segment, IPC_SET, &shm_settings ) == -1 ) {
		UNIX_ERROR( "shmctl() failed" );
		RETURN_INT( -1 );
	}

	RETURN_INT( 0 );
}
