/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <search.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"
#include "dfile_dynamic.h"
#include "sexpr.h"
#include "where.h"
#include "dfile_diff.h"

/*
** This function assigns field binds within the record layout.
*/
int assign_non_key_bind( dfile_bind_t ***ret_non_key_bind_tbl, dfile_bind_t *source_bind, unsigned short source_bind_cnt, char **key_tbl, unsigned short key_tbl_cnt, dfile_bind_t **sorted_bind, unsigned short sorted_bind_cnt )
{
	unsigned short	ndx;
	size_t	alloc_size, tbl_cnt;
	dfile_bind_t	bind, *source, **bind_entry, **non_key_bind_tbl;
	char	**key_entry;

	assert( ret_non_key_bind_tbl != (dfile_bind_t ***)0 );
	assert( source_bind != (dfile_bind_t *)0 );
	assert( key_tbl != (char **)0 );
	assert( sorted_bind != (dfile_bind_t **)0 );

	DEBUG_FUNC_START;

	*ret_non_key_bind_tbl = (dfile_bind_t **)0;

	alloc_size = sizeof( dfile_bind_t * ) * (size_t)source_bind_cnt;
	non_key_bind_tbl = (dfile_bind_t **)malloc( alloc_size );
	if ( non_key_bind_tbl == (dfile_bind_t **)0 ) {
		UNIX_ERROR( "malloc() failed" );
		RETURN_INT( -1 );
	}

	source = &bind;
	tbl_cnt = key_tbl_cnt;

	for ( ndx = (unsigned short)0; ndx < source_bind_cnt; ++ndx ) {
		bind.field_name = source_bind->field_name;

		bind_entry = (dfile_bind_t **)bsearch( (void *)&source, (void *)sorted_bind, (size_t)sorted_bind_cnt, sizeof( dfile_bind_t * ), dfile_bind_field_name_cmp );

		if ( bind_entry == (dfile_bind_t **)0 ) {
			if ( Debug ) {
				(void) fputs( "Field [", stderr );
				(void) fputs( source_bind->field_name, stderr );
				(void) fputs( "] was not defined in both input DFiles.\n", stderr );
			}
			non_key_bind_tbl[ ndx ] = (dfile_bind_t *)0;
			++source_bind;
			continue;
		}

		key_entry = (char **)lfind( (void *)source_bind->field_name, (void *)key_tbl, &tbl_cnt, sizeof( char * ), (int (*)(const void *, const void *))strcasecmp );

		if ( key_entry != (char **)0 ) {
			if ( Debug ) {
				(void) fputs( "Field [", stderr );
				(void) fputs( source_bind->field_name, stderr );
				(void) fputs( "] is a key field.\n", stderr );
			}
			non_key_bind_tbl[ ndx ] = (dfile_bind_t *)0;
			++source_bind;
			continue;
		}

		non_key_bind_tbl[ ndx ] = *bind_entry;
		++source_bind;
	}

	*ret_non_key_bind_tbl = non_key_bind_tbl;

	RETURN_INT( 0 );
}
