typedef struct {
	char	*dfile_name;
	dfile_t	*dfile;
	void	*where;
	dfile_bind_t	**key_bind_tbl;
} input_dfile_t;

typedef struct {
	char	*dfile_name;
	dfile_t	*dfile;
	dfile_bind_t	**key_bind_tbl;
	unsigned short	*input_map_tbl;
} output_dfile_t;

typedef struct {
	char	*change_seq_nbr;
	char	*field_name;
	char	*original_value;
	char	*subsequent_value;
	size_t	change_seq_nbr_len;
	size_t	field_name_len;
	size_t	original_value_len;
	size_t	subsequent_value_len;
} change_data_t;

int get_args( int, char * const [], char **, char **, char **, char **, dfile_tag_t **, unsigned short *, char **, char **, char **, char **, char ** );

int open_input_dfile( dfile_t **, const char *, dfile_tag_t *, unsigned short );
int open_output_dfile( dfile_t **, const char *, dfile_tag_t *, unsigned short );
int prepare_input_dfile( input_dfile_t *, dfile_tag_t *, unsigned short, char **, unsigned short, const char * );

int diff_records( input_dfile_t *, input_dfile_t *, output_dfile_t *, output_dfile_t *, dfile_t *, change_data_t *, dfile_t *, unsigned short *, unsigned short, dfile_bind_t ** );

void copy_input_to_output( dfile_bind_t *, dfile_bind_t *, unsigned short *, unsigned short );

int assign_non_key_bind( dfile_bind_t ***, dfile_bind_t *, unsigned short, char **, unsigned short, dfile_bind_t **, unsigned short );

int open_change_data_dfile( change_data_t **, dfile_t **, const char *, dfile_tag_t *, unsigned short );

int compare_non_key_data( int *, change_data_t *, dfile_t *, dfile_bind_t *, unsigned short, dfile_bind_t ** );

#define NULL_CHECK( x ) ( ( ( x ) == (const char *)0 ) ? "null" : ( x ) )
