/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_dynamic.h"
#include "dfile_utility.h"
#include "dfile_diff.h"

/*
** This program identifies differences between dfiles.
*/
int main( int argc, char **argv )
{
	input_dfile_t	original_dfile, subsequent_dfile;
	output_dfile_t	added_dfile, deleted_dfile;
	char	*key_dfile_name, *change_data_dfile_name;
	char	*key_argument, **key_field_tbl;
	char	*original_filter_file_name, *subsequent_filter_file_name;
	dfile_t	*key_dfile, *change_data_dfile;
	dfile_tag_t	*dfile_tag_tbl;
	unsigned short	dfile_tag_tbl_cnt, *key_map_tbl;
	dfile_bind_t	**non_key_bind_tbl;
	unsigned long	key_field_tbl_cnt;
	change_data_t	*change_data;

	(void) memset( (void *)&original_dfile, 0, sizeof( original_dfile ) );
	(void) memset( (void *)&subsequent_dfile, 0, sizeof( subsequent_dfile ) );
	(void) memset( (void *)&added_dfile, 0, sizeof( added_dfile ) );
	(void) memset( (void *)&deleted_dfile, 0, sizeof( deleted_dfile ) );

	if ( get_args( argc, argv, &original_dfile.dfile_name, &subsequent_dfile.dfile_name, &added_dfile.dfile_name, &deleted_dfile.dfile_name, &dfile_tag_tbl, &dfile_tag_tbl_cnt, &key_argument, &original_filter_file_name, &subsequent_filter_file_name, &key_dfile_name, &change_data_dfile_name ) == -1 ) {
		return 5;
	}

	DEBUG_FUNC_START;

	if ( parse_list( &key_field_tbl, &key_field_tbl_cnt, key_argument, ',' ) == -1 ) {
		RETURN_INT( 10 );
	}

	if ( prepare_input_dfile( &original_dfile, dfile_tag_tbl, dfile_tag_tbl_cnt, key_field_tbl, key_field_tbl_cnt, original_filter_file_name ) == -1 ) {
		RETURN_INT( 15 );
	}

	if ( prepare_input_dfile( &subsequent_dfile, dfile_tag_tbl, dfile_tag_tbl_cnt, key_field_tbl, key_field_tbl_cnt, subsequent_filter_file_name ) == -1 ) {
		RETURN_INT( 20 );
	}

	if ( added_dfile.dfile_name != (char *)0 ) {
		if ( open_output_dfile( &added_dfile.dfile, added_dfile.dfile_name, dfile_tag_tbl, dfile_tag_tbl_cnt ) == -1 ) {
			RETURN_INT( 25 );
		}

		if ( assign_field_bind( &added_dfile.key_bind_tbl, key_field_tbl, key_field_tbl_cnt, added_dfile.dfile->sorted_bind, added_dfile.dfile->bind_cnt ) == -1 ) {
			RETURN_INT( 30 );
		}

		if ( map_dfile_field_names( &added_dfile.input_map_tbl, added_dfile.dfile->bind, added_dfile.dfile->bind_cnt, subsequent_dfile.dfile->bind, subsequent_dfile.dfile->sorted_bind, subsequent_dfile.dfile->bind_cnt ) == -1 ) {
			RETURN_INT( 35 );
		}
	}

	if ( deleted_dfile.dfile_name != (char *)0 ) {
		if ( open_output_dfile( &deleted_dfile.dfile, deleted_dfile.dfile_name, dfile_tag_tbl, dfile_tag_tbl_cnt ) == -1 ) {
			RETURN_INT( 40 );
		}

		if ( assign_field_bind( &deleted_dfile.key_bind_tbl, key_field_tbl, key_field_tbl_cnt, deleted_dfile.dfile->sorted_bind, deleted_dfile.dfile->bind_cnt ) == -1 ) {
			RETURN_INT( 45 );
		}

		if ( map_dfile_field_names( &deleted_dfile.input_map_tbl, deleted_dfile.dfile->bind, deleted_dfile.dfile->bind_cnt, original_dfile.dfile->bind, original_dfile.dfile->sorted_bind, original_dfile.dfile->bind_cnt ) == -1 ) {
			RETURN_INT( 50 );
		}
	}

	if ( open_output_dfile( &key_dfile, key_dfile_name, dfile_tag_tbl, dfile_tag_tbl_cnt ) == -1 ) {
		RETURN_INT( 55 );
	}

	if ( key_dfile != (dfile_t *)0 ) {
		if ( map_dfile_field_names( &key_map_tbl, key_dfile->bind, key_dfile->bind_cnt, original_dfile.dfile->bind, original_dfile.dfile->sorted_bind, original_dfile.dfile->bind_cnt ) == -1 ) {
			RETURN_INT( 60 );
		}
	}

	if ( assign_non_key_bind( &non_key_bind_tbl, original_dfile.dfile->bind, original_dfile.dfile->bind_cnt, key_field_tbl, key_field_tbl_cnt, subsequent_dfile.dfile->sorted_bind, subsequent_dfile.dfile->bind_cnt ) == -1 ) {
			RETURN_INT( 65 );
	}

	if ( open_change_data_dfile( &change_data, &change_data_dfile, change_data_dfile_name, dfile_tag_tbl, dfile_tag_tbl_cnt ) == -1 ) {
		RETURN_INT( 70 );
	}

	if ( diff_records( &original_dfile, &subsequent_dfile, &added_dfile, &deleted_dfile, key_dfile, change_data, change_data_dfile, key_map_tbl, (unsigned short)key_field_tbl_cnt, non_key_bind_tbl ) == -1 ) {
		return 75;
	}

	if ( added_dfile.dfile != (dfile_t *)0 ) {
		if ( dfile_write_close( added_dfile.dfile ) == -1 ) {
			RETURN_INT( 80 );
		}
	}

	if ( deleted_dfile.dfile != (dfile_t *)0 ) {
		if ( dfile_write_close( deleted_dfile.dfile ) == -1 ) {
			RETURN_INT( 85 );
		}
	}

	if ( key_dfile != (dfile_t *)0 ) {
		if ( dfile_write_close( key_dfile ) == -1 ) {
			RETURN_INT( 90 );
		}
	}

	if ( change_data_dfile != (dfile_t *)0 ) {
		if ( dfile_write_close( change_data_dfile ) == -1 ) {
			RETURN_INT( 95 );
		}
	}

	RETURN_INT( 0 );
}
