/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"
#include "dfile_diff.h"


/*
** This function opens a data file for writing.
*/
int open_change_data_dfile( change_data_t **ret_cd, dfile_t **dfile, const char *dfile_name, dfile_tag_t *tag_tbl, unsigned short tag_tbl_cnt )
{
	static change_data_t	cd;

	static dfile_bind_t	bind_tbl[] = {
	{ "change_seq_nbr", &cd.change_seq_nbr, &cd.change_seq_nbr_len },
	{ "field_name", &cd.field_name, &cd.field_name_len },
	{ "original_value", &cd.original_value, &cd.original_value_len },
	{ "subsequent_value", &cd.subsequent_value, &cd.subsequent_value_len }
	};

	const unsigned short	bind_tbl_cnt = sizeof( bind_tbl ) / sizeof( dfile_bind_t );

	dfile_cfg_t	cfg;
	const unsigned short	blocks_per_buffer_cnt = 4;
	const unsigned short	buffer_cnt = 1;
	const dfile_open_mode_t	dfile_open_mode = Dfile_trunc;

	assert( ret_cd != (change_data_t **)0 );
	assert( dfile != (dfile_t **)0 );

	DEBUG_FUNC_START;

	*dfile = (dfile_t *)0;

	if ( dfile_name == (const char *)0 ) {
		if ( Debug ) {
			(void) fputs( "Output dfile name was unspecified.\n", stderr );
		}
		RETURN_INT( 0 );
	}

	if ( dfile_cfg( &cfg, dfile_name ) == -1 ) {
		RETURN_INT( -1 );
	}

	*dfile = dfile_write_open( &cfg, bind_tbl, bind_tbl_cnt, tag_tbl, tag_tbl_cnt, blocks_per_buffer_cnt, buffer_cnt, dfile_open_mode );

	if ( *dfile == (dfile_t *)0 ) {
		RETURN_INT( -1 );
	}

	*ret_cd = &cd;

	RETURN_INT( 0 );
}
