/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <sys/types.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "sexpr.h"
#include "dfile_exec.h"


/*
** This function assigns information from control structure.
*/
int assign_exit_values( unsigned char *exit_value, sexpr_t *field, unsigned short tuple_cnt )
{
	long	int_value;
	char	*end;

	assert( exit_value != (unsigned char *)0 );

	DEBUG_FUNC_START;

	while ( field != (sexpr_t *)0 ) {
		if ( SEXPR_CAR_TYPE( field ) != string_sexpr ) {
			CONTROL_SYNTAX_ERROR( "expected a string", tuple_cnt );
			RETURN_INT( -1 );
		}

		int_value = strtol( SEXPR_CAR_STRING( field ), &end, 10 );
		if ( end == SEXPR_CAR_STRING( field ) || *end != (char)0 || int_value > (long)UCHAR_MAX || int_value < 0L ) {
			CONTROL_SYNTAX_ERROR( "expected a number between 0 and 255", tuple_cnt );
			RETURN_INT( -1 );
		}

		exit_value[ int_value ] = (unsigned char)1;

		assert( SEXPR_CDR_TYPE( field ) == list_sexpr );

		field = SEXPR_CDR_LIST( field );
	}

	RETURN_INT( 0 );
}
