/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "sexpr.h"
#include "dfile_exec.h"


int assign_string( char **result, sexpr_t *field, const char *desc, unsigned short tuple_cnt )
{
	char	msg[120];

	assert( result != (char **)0 );
	assert( field != (sexpr_t *)0 );
	assert( desc != (const char *)0 );

	if ( field == (sexpr_t *)0 || SEXPR_CAR_TYPE( field ) != string_sexpr ) {
		(void) strcpy( msg, "expected a string after " );
		(void) strncat( msg, desc, (size_t)60 );
		CONTROL_SYNTAX_ERROR( msg, tuple_cnt );
		RETURN_INT( -1 );
	}

	*result = SEXPR_CAR_STRING( field );

	if ( Debug ) {
		(void) fprintf( stderr, "%s [%s]\n", desc, *result );
	}

	RETURN_INT( 0 );
}
