/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "sexpr.h"
#include "dfile_exec.h"

static int replace_token( char **, char **, const char *, const char * );


/*
** This function searches for %n and %s flags. These flags are replaced with
** slice sequence number and slice name respectively.
*/
int substitute_tokens( char **new_arg, const char *sequence, const char *slice_name )
{
	char	*token, *arg;

	assert( new_arg != (char **)0 );
	assert( sequence != (const char *)0 );

	DEBUG_FUNC_START;

	arg = *new_arg;

	while ( ( token = strchr( arg, '%' ) ) != (char *)0 ) {
		assert( token >= arg );
		switch ( token[ 1 ] ) {
		case 's':
			if ( replace_token( new_arg, &arg, token, slice_name ) == -1 ) {
				RETURN_INT( -1 );
			}
			break;

		case 'n':
			if ( replace_token( new_arg, &arg, token, sequence ) == -1 ) {
				RETURN_INT( -1 );
			}
			break;

		default:
			++arg;
		}
	}


	arg = (char *)strenv( *new_arg );
	if ( arg == (char *)0 ) {
		RETURN_INT( -1 );
	}

	*new_arg = strdup( arg );
	if ( *new_arg == (char *)0 ) {
		UNIX_ERROR( "strdup() failed" );
		RETURN_INT( -1 );
	}

	RETURN_INT( 0 );
}

static int replace_token( char **beg, char **arg, const char *token, const char *replacement )
{
	size_t	prefix_len, suffix_len, replacement_len, alloc_size;
	size_t	prefix_token_len, arg_len;
	const size_t	token_len = 2;
	char	*new, *ptr;

	if ( Debug ) {
		(void) fprintf( stderr, "before [%s]\n", *beg );
	}

	replacement_len = strlen( replacement );
	arg_len = strlen( *beg );

	alloc_size = arg_len - token_len + replacement_len + (size_t)1;

	new = (char *)malloc( alloc_size );
	if ( new == (char *)0 ) {
		UNIX_ERROR( "malloc() failed" );
		return -1;
	}

	ptr = new;

	prefix_len = (size_t)( token - *beg );
	prefix_token_len = prefix_len + token_len;
	suffix_len = arg_len - prefix_token_len;

	(void) memcpy( (void *)ptr, (void *)*beg, prefix_len );
	ptr += prefix_len;
	(void) memcpy( (void *)ptr, (void *)replacement, replacement_len );
	ptr += replacement_len;
	(void) memcpy( (void *)ptr, (void *)( *beg + prefix_token_len ), suffix_len + 1 );
	ptr += suffix_len;

	*ptr = (char)0;
	
	free( *beg );

	*beg = new;
	*arg = new + prefix_len + replacement_len;

	if ( Debug ) {
		(void) fprintf( stderr, "after [%s]\n", *beg );
	}

	return 0;
}
