/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <sys/types.h>
#include <unistd.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "sexpr.h"
#include "dfile_exec.h"

/*
** Record layout:
**	1. GMT Time
**	2. Job Name
**	3. Step Name
**	4. Partition
**	5. Process ID
**	6. Action Code - S)tart, E)nd
**	7. Exit Code
**	8. Signal
*/

int write_log_record( int fd, const char *job_name, const char *step_name, const char *partition, pid_t pid, const char action_code, int *exit_code, int *signal_value )
{
	char	buf[512];
	time_t	gmt;
	int	len, ret;
	const char	*exit_code_fmt, *signal_value_fmt;

	assert( fd >= 0 );
	assert( action_code == 'S' || action_code == 'E' );

	DEBUG_FUNC_START;

	(void) time( &gmt );

	if ( job_name == (const char *)0 ) {
		job_name = "";
	}

	if ( step_name == (const char *)0 ) {
		step_name = "";
	}

	if ( partition == (const char *)0 ) {
		partition = "";
	}

	if ( exit_code == (int *)0 ) {
		exit_code_fmt = "";
	} else {
		exit_code_fmt = itoa( *exit_code );
		if ( exit_code_fmt == (const char *)0 ) {
			exit_code_fmt = "";
		}
	}

	if ( signal_value == (int *)0 ) {
		signal_value_fmt = "";
	} else {
		signal_value_fmt = itoa( *signal_value );
		if ( signal_value_fmt == (const char *)0 ) {
			signal_value_fmt = "";
		}
	}

	len = snprintf( buf, sizeof( buf ), "%ld|%.50s|%.50s|%.50s|%d|%c|%.8s|%.8s\n", gmt, job_name, step_name, partition, pid, action_code, exit_code_fmt, signal_value_fmt );

	ret = write( fd, buf, len );

	if ( ret < 0 ) {
		UNIX_ERROR( "write() failed" );
		RETURN_INT( -1 );
	}

	if ( ret != len ) {
		RETURN_INT( -1 );
	}

	RETURN_INT( 0 );
}
