/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <sys/types.h>
#include <sys/resource.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "sexpr.h"
#include "dfile_exec.h"


static void calc_usage( unsigned long *, unsigned long *, unsigned long *, time_t );

/*
** This function writes collective CPU time to stderr of spawned processes.
*/
void write_system_usage( const char *step_desc, time_t usr_time, time_t sys_time, time_t real_time )
{
	unsigned long	usr_hours, usr_minutes, usr_seconds;
	unsigned long	sys_hours, sys_minutes, sys_seconds;
	unsigned long	real_hours, real_minutes, real_seconds;
#if 0
	long	page_size_kb;
#endif

	DEBUG_FUNC_START;

#if 0
	if ( getrusage( RUSAGE_CHILDREN, &r_usage ) == -1 ) {
		UNIX_ERROR( "getrusage() failed" );
		RETURN_VOID;
	}

	print_time( "user time:", r_usage.ru_utime.tv_sec );
	print_time( "system time:", r_usage.ru_stime.tv_sec );
#endif

	calc_usage( &usr_hours, &usr_minutes, &usr_seconds, usr_time );
	calc_usage( &sys_hours, &sys_minutes, &sys_seconds, sys_time );
	calc_usage( &real_hours, &real_minutes, &real_seconds, real_time );

	(void) printf( "%s real %luh%02lum%02lus, user %luh%02lum%02lus, system %luh%02lum%02lus, %s\n", get_ctime(), real_hours, real_minutes, real_seconds, usr_hours, usr_minutes, usr_seconds, sys_hours, sys_minutes, sys_seconds, step_desc );

#if 0
	page_size_kb = getpagesize() / 1024;

	fprintf( stderr, "maximum resident set size (KBytes): %ld\n", r_usage.ru_maxrss * page_size_kb );
	fprintf( stderr, "integral resident set size (KBytes): %ld\n", r_usage.ru_idrss * page_size_kb );
	fprintf( stderr, "page faults not requiring physical I/O: %ld\n", r_usage.ru_minflt );
	fprintf( stderr, "page faults requiring physical I/O: %ld\n", r_usage.ru_majflt );
	fprintf( stderr, "swaps: %ld\n", r_usage.ru_nswap );
	fprintf( stderr, "block input operations: %ld\n", r_usage.ru_inblock );
	fprintf( stderr, "block output operations: %ld\n", r_usage.ru_oublock );
	fprintf( stderr, "signals received: %ld\n", r_usage.ru_nsignals );
	fprintf( stderr, "voluntary context switches: %ld\n", r_usage.ru_nvcsw );
	fprintf( stderr, "involuntary context switches: %ld\n", r_usage.ru_nivcsw );
#endif

	RETURN_VOID;
}

static void calc_usage( unsigned long *hours, unsigned long *minutes, unsigned long *seconds, time_t tot_sec )
{
	const unsigned long	seconds_per_minute = 60;
	const unsigned long	minutes_per_hour = 60;
	const unsigned long	seconds_per_hour = seconds_per_minute * minutes_per_hour;

	*hours = tot_sec / seconds_per_hour;
	tot_sec -= *hours * seconds_per_hour;

	*minutes = tot_sec / seconds_per_minute;
	tot_sec -= *minutes * seconds_per_minute;

	*seconds = tot_sec;
}
