/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */


typedef struct {
	char	*direction;
	char	*field_name;
} field_direction_t;

typedef struct {
	field_direction_t	field[ 2 ];
} map_field_t;

typedef struct {
	char		*dfile_name;
	map_field_t	*map_field_tbl;
	unsigned short	map_field_tbl_cnt;
	sexpr_t		*record_filter;
	dfile_tag_t     *tag;
	unsigned short  tag_cnt;
	unsigned short  blocks_per_buffer_cnt;
	unsigned short  buffer_cnt;
	void		*where;
} input_ctl_t;

typedef struct {
	size_t	rec_cnt;
	size_t	rec_size;
	size_t	field_cnt;
	size_t	*field_offset;
	char	*data;
	dfile_bind_t	*bind;
	char	***key;

	char	**input_key_tbl;
	unsigned long	matched_record_offset;
} shm_t;

typedef struct {
	char		*dfile_name;
	char		unique_join_flag;	/* (F)irst, (L)ast */
	char		inner_outer_join_flag;	/* (I)nner, (O)uter */
	char		**copy_field_tbl;
	unsigned short	copy_field_tbl_cnt;
	char		**key_field_tbl;
	unsigned short	key_field_tbl_cnt;
	map_field_t	*map_field_tbl;
	unsigned short	map_field_tbl_cnt;
	char		*status_field;
	sexpr_t		*record_filter;
	dfile_tag_t     *tag;
	unsigned short  tag_cnt;
	unsigned short  blocks_per_buffer_cnt;
	unsigned short  buffer_cnt;
	char		*ipc_key;

	dfile_t		*dfile;
	dfile_bind_t	**input_key_tbl;

	dfile_bind_t	**join_key_tbl;
	unsigned short	*join_key_ndx_tbl;

	unsigned short	*join_field_ndx_tbl;
	dfile_bind_t	**join_field_tbl;

	dfile_bind_t	**output_field_tbl;
	void		*where;
	field_t		**key_record;
	size_t		*key_record_size;
	field_t		**copy_record;
	size_t		*copy_record_size;
	unsigned long	record_cnt;
	unsigned long	alloc_record_cnt;
	dfile_bind_t	*outer_join_status_field;

	shm_t		shm;
	int		initial_read_flag;
	int		end_of_file_flag;
} join_ctl_t;

typedef struct {
	char	*dfile_name;
	sexpr_t		*record_filter;
	dfile_tag_t     *tag;
	unsigned short  tag_cnt;
	unsigned short  blocks_per_buffer_cnt;
	unsigned short  buffer_cnt;
	dfile_open_mode_t dfile_open_mode;
	void		*where;
} output_ctl_t;

void copy_input_to_output( dfile_bind_t **, const dfile_bind_t **, unsigned short );

int get_args( int, char * const [], char **, char **, int *, int *, dfile_tag_t **, unsigned short *, char **, char **, char **, char *, char **, char *, char **, char **, char **, char **, char ** );

int get_join_records( field_t ***, size_t **, field_t ***, size_t **, unsigned long *, dfile_t *, const dfile_bind_t **, const dfile_bind_t **, unsigned short, void *, int *, int *, const dfile_bind_t **, unsigned short, unsigned long );

int join_files( dfile_t *, const dfile_bind_t **, dfile_bind_t **, unsigned short, void *, void *, join_ctl_t *, unsigned short );

int write_join( dfile_t *, join_ctl_t *, unsigned short, void * );

int write_record( dfile_t *, void * );

void copy_record_to_bind( dfile_bind_t **, field_t *, unsigned short );

int compile_io_filters( void **, void **, sexpr_t *, sexpr_t *, dfile_t *, dfile_t * );

int assign_control_information( input_ctl_t *, join_ctl_t **, unsigned short *, output_ctl_t *, const char *, dfile_tag_t *, unsigned short );

int level1_syntax( input_ctl_t *, join_ctl_t **, unsigned short *, output_ctl_t *, sexpr_t *, unsigned short, dfile_tag_t *, unsigned short );

void control_syntax_error( const char *, const char *, int, unsigned short );

int assign_input( input_ctl_t *, sexpr_t *, unsigned short, dfile_tag_t *, unsigned short );

int assign_input_dfile( input_ctl_t *, sexpr_t *, unsigned short );

int assign_tag( dfile_tag_t **, unsigned short *, sexpr_t *, unsigned short );

int assign_ushort( unsigned short *, sexpr_t *, unsigned short );

int assign_list_pair( char **, char **, sexpr_t *, unsigned short );

int assign_map_fields( map_field_t **, unsigned short *, sexpr_t *, unsigned short );

int assign_input_dfile_attribute( input_ctl_t *, sexpr_t *, unsigned short );

int assign_copy_fields( char ***, unsigned short *, sexpr_t *, unsigned short );

int assign_join( join_ctl_t **, unsigned short *, sexpr_t *, unsigned short, dfile_tag_t *, unsigned short );

int assign_join_dfile( join_ctl_t *, sexpr_t *, unsigned short );

int assign_key_fields( char ***, unsigned short *, sexpr_t *, unsigned short );

int assign_join_dfile_attribute( join_ctl_t *, sexpr_t *, unsigned short );

int assign_outer_join( char **, sexpr_t *, unsigned short );

int assign_output( output_ctl_t *, sexpr_t *, unsigned short, dfile_tag_t *, unsigned short );

int assign_output_dfile( output_ctl_t *, sexpr_t *, unsigned short );

int assign_open_mode( dfile_open_mode_t *, sexpr_t *, unsigned short );

void dump_input_ctl( input_ctl_t * );

void dump_join_ctl( join_ctl_t *, unsigned short );

void dump_output_ctl( output_ctl_t * );

int open_input_dfile( dfile_t **, const char *, dfile_tag_t *, unsigned short, unsigned short, unsigned short );

int open_output_dfile( dfile_t **, const char *, dfile_tag_t *, unsigned short, unsigned short, unsigned short, dfile_open_mode_t );

void find_field_alias( char **, const char *, map_field_t *, unsigned short, const char *, const char * );

int map_fields( dfile_bind_t ***, char **, unsigned short, dfile_bind_t **, unsigned short, map_field_t *, unsigned short, const char *, const char * );

int map_field_names_with_alias( dfile_bind_t ***, dfile_bind_t ***, unsigned short *, dfile_bind_t *, unsigned short, dfile_bind_t **, unsigned short, map_field_t *, unsigned short, const char *, const char * );

int prepare_joins( join_ctl_t *, unsigned short, dfile_t *, dfile_t * );

int attach_shared_memory( shm_t *, const char *, unsigned short *, unsigned short );

void get_shm_join_records( shm_t *, unsigned long *, dfile_bind_t **, unsigned short );

void copy_shm_record_to_bind( dfile_bind_t **, unsigned long, shm_t *, const unsigned short *, unsigned short );

int assign_cmd_line_information( input_ctl_t *, join_ctl_t **, unsigned short *, output_ctl_t *, char *, const char *, const char *, const char *, const char *, dfile_tag_t *, unsigned short, char *, char *, char, char, char *, const char *, char *, int, int );

int copy_record( field_t **, size_t *, const dfile_bind_t **, unsigned short );

int compare_field_bind( const field_t *, const dfile_bind_t **, unsigned short );

void null_fields( dfile_bind_t **, unsigned short );

int create_shm_bind( dfile_bind_t **, unsigned short *, dfile_bind_t ***, const char * );

#define NULL_CHECK( x ) ( ( ( x ) == (const char *)0 ) ? "null" : ( x ) )
