/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_dynamic.h"
#include "dfile_utility.h"
#include "sexpr.h"
#include "dfile_join.h"

/*
** This program joins records between dfiles.
*/
int main( int argc, char **argv )
{
	char	*input_dfile_name, *output_dfile_name;
	char	*key_argument, *join_dfile_name;
	char	*data_field_argument, *outer_join_status_field;
	char	*input_filter_file_name, *join_filter_file_name;
	char	*output_filter_file_name;
	dfile_t	*output_dfile, *input_dfile;
	int	thread_input_flag, thread_output_flag;
	dfile_tag_t	*dfile_tag_tbl;
	unsigned short	dfile_tag_tbl_cnt;
	char	*control_file, *ipc_key;
	dfile_bind_t	**input_field_map_tbl, **output_field_map_tbl;
	unsigned short	io_field_map_tbl_cnt;
	char	inner_outer_join_flag, unique_join;
	int	ret;
	input_ctl_t	input_ctl;
	join_ctl_t	*join_ctl_tbl;
	unsigned short	join_ctl_tbl_cnt;
	output_ctl_t	output_ctl;

	if ( get_args( argc, argv, &input_dfile_name, &output_dfile_name, &thread_input_flag, &thread_output_flag, &dfile_tag_tbl, &dfile_tag_tbl_cnt, &key_argument, &join_dfile_name, &data_field_argument, &inner_outer_join_flag, &outer_join_status_field, &unique_join, &input_filter_file_name, &join_filter_file_name, &output_filter_file_name, &control_file, &ipc_key ) == -1 ) {
		return 5;
	}

	DEBUG_FUNC_START;

	if ( control_file == (const char *)0 ) {
		ret = assign_cmd_line_information( &input_ctl, &join_ctl_tbl, &join_ctl_tbl_cnt, &output_ctl, input_dfile_name, key_argument, data_field_argument, input_filter_file_name, output_filter_file_name, dfile_tag_tbl, dfile_tag_tbl_cnt, output_dfile_name, join_dfile_name, inner_outer_join_flag, unique_join, outer_join_status_field, join_filter_file_name, ipc_key, thread_input_flag, thread_output_flag );

		if ( ret == -1 ) {
			RETURN_INT( 7 );
		}
	} else {
		ret = assign_control_information( &input_ctl, &join_ctl_tbl, &join_ctl_tbl_cnt, &output_ctl, control_file, dfile_tag_tbl, dfile_tag_tbl_cnt );

		if ( ret == -1 ) {
			RETURN_INT( 10 );
		}
	}

	if ( open_input_dfile( &input_dfile, input_ctl.dfile_name, input_ctl.tag, input_ctl.tag_cnt, input_ctl.blocks_per_buffer_cnt, input_ctl.buffer_cnt ) == -1 ) {
		RETURN_INT( 20 );
	}

	if ( open_output_dfile( &output_dfile, output_ctl.dfile_name, output_ctl.tag, output_ctl.tag_cnt, output_ctl.blocks_per_buffer_cnt, output_ctl.buffer_cnt, output_ctl.dfile_open_mode ) == -1 ) {
		RETURN_INT( 30 );
	}

	if ( prepare_joins( join_ctl_tbl, join_ctl_tbl_cnt, input_dfile, output_dfile ) == -1 ) {
		RETURN_INT( 35 );
	}

	if ( map_field_names_with_alias( &input_field_map_tbl, &output_field_map_tbl, &io_field_map_tbl_cnt, output_dfile->bind, output_dfile->bind_cnt, input_dfile->sorted_bind, input_dfile->bind_cnt, input_ctl.map_field_tbl, input_ctl.map_field_tbl_cnt, "input", "output" ) == -1 ) {
		RETURN_INT( 55 );
	}

	if ( compile_io_filters( &input_ctl.where, &output_ctl.where, input_ctl.record_filter, output_ctl.record_filter, input_dfile, output_dfile ) == -1 ) {
		RETURN_INT( 57 );
	}

	while ( dfile_read( input_dfile ) == 0 ) {
		if ( join_files( output_dfile, (const dfile_bind_t **)input_field_map_tbl, output_field_map_tbl, io_field_map_tbl_cnt, input_ctl.where, output_ctl.where, join_ctl_tbl, join_ctl_tbl_cnt ) == -1 ) {
			RETURN_INT( 60 );
		}
	}

	if ( input_dfile->error != Dfile_all_data_processed ) {
		FPUT_SRC_CODE( stderr );
		(void) fputs( "Failed to read all data.\n", stderr );
		RETURN_INT( 65 );
	}

#if 0
	(void) dfile_read_close( input_dfile );
#endif

	if ( dfile_write_close( output_dfile ) == -1 ) {
		RETURN_INT( 70 );
	}

	RETURN_INT( 0 );
}
