/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_dynamic.h"
#include "dfile_utility.h"
#include "sexpr.h"
#include "dfile_join.h"


/*
** This function assigns field offsets within the record layout.
*/
int map_fields( dfile_bind_t ***ret_key_bind_tbl, char **key_tbl, unsigned short key_tbl_cnt, dfile_bind_t **sorted_bind, unsigned short bind_cnt, map_field_t *map_field_tbl, unsigned short map_field_tbl_cnt, const char *source, const char *target )
{
	size_t	alloc_size;
	char	*field_alias;
	dfile_bind_t	**bind_entry, bind, **key_bind_tbl, *key_bind;

	assert( ret_key_bind_tbl != (dfile_bind_t ***)0 );
	assert( key_tbl != (char **)0 );
	assert( sorted_bind != (dfile_bind_t **)0 );
	assert( source != (const char *)0 );
	assert( target != (const char *)0 );

	DEBUG_FUNC_START;

	*ret_key_bind_tbl = (dfile_bind_t **)0;

	alloc_size = sizeof( dfile_bind_t *) * (size_t)key_tbl_cnt;
	key_bind_tbl = (dfile_bind_t **)malloc( alloc_size );
	if ( key_bind_tbl == (dfile_bind_t **)0 ) {
		UNIX_ERROR( "malloc() failed" );
		RETURN_INT( -1 );
	}

	*ret_key_bind_tbl = key_bind_tbl;

	for ( ; key_tbl_cnt > (unsigned short)0; --key_tbl_cnt ) {
		find_field_alias( &field_alias, *key_tbl, map_field_tbl, map_field_tbl_cnt, source, target );

		if ( field_alias == (char *)0 ) {
			bind.field_name = *key_tbl;
		} else {
			bind.field_name = field_alias;
		}

		key_bind = &bind;

		bind_entry = (dfile_bind_t **)bsearch( (void *)&key_bind, sorted_bind, bind_cnt, sizeof( dfile_bind_t * ), dfile_bind_field_name_cmp );

		if ( bind_entry == (dfile_bind_t **)0 ) {
			FPUT_SRC_CODE( stderr );
			(void) fputs( "Key field [", stderr );
			(void) fputs( *key_tbl, stderr );
			(void) fputs( "] was not defined as a DFile field.\n", stderr );
			RETURN_INT( -1 );
		}

		*key_bind_tbl = *bind_entry;

		++key_bind_tbl;
		++key_tbl;
	}

	RETURN_INT( 0 );
}
