/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"
#include "sexpr.h"
#include "dfile_dynamic.h"
#include "dfile_sort.h"


/*
** This function assigns field offsets within the input record layout.
*/
int assign_order_by_field_offset( unsigned short **ret_key_ndx_tbl, order_by_t *key_tbl, unsigned short key_tbl_cnt, dfile_bind_t *bind_tbl, unsigned short bind_tbl_cnt, dfile_bind_t **sorted_bind )
{
	unsigned short	*key_ndx_tbl;
	size_t	alloc_size;
	dfile_bind_t	key, *key_ptr, **entry;

	assert( ret_key_ndx_tbl != (unsigned short **)0 );
	assert( key_tbl != (order_by_t *)0 );
	assert( bind_tbl != (dfile_bind_t *)0 );
	assert( sorted_bind != (dfile_bind_t **)0 );

	DEBUG_FUNC_START;

	*ret_key_ndx_tbl = (unsigned short *)0;

	alloc_size = sizeof( unsigned short ) * (size_t)key_tbl_cnt;
	key_ndx_tbl = (unsigned short *)malloc( alloc_size );
	if ( key_ndx_tbl == (unsigned short *)0 ) {
		unix_error( "malloc() failed", __FILE__, __LINE__ );
		RETURN_INT( -1 );
	}

	*ret_key_ndx_tbl = key_ndx_tbl;
	key_ptr = &key;

	for ( ; key_tbl_cnt > (unsigned short)0; --key_tbl_cnt ) {
		key.field_name = key_tbl->field_name;

		entry = (dfile_bind_t **)bsearch( (void *)&key_ptr, (void *)sorted_bind, (size_t)bind_tbl_cnt, sizeof( dfile_bind_t * ), dfile_bind_field_name_cmp );

		if ( entry == (dfile_bind_t **)0 ) {
			FPUT_SRC_CODE( stderr );
			(void) fputs( "Key field [", stderr );
			(void) fputs( key_tbl->field_name, stderr );
			(void) fputs( "] was not defined as a DFile field.\n", stderr );
			RETURN_INT( -1 );
		}

		assert( *entry >= bind_tbl );

		*key_ndx_tbl = (unsigned short)( *entry - bind_tbl );

		++key_tbl;
		++key_ndx_tbl;
	}

	RETURN_INT( 0 );
}
