/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <limits.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"
#include "sexpr.h"
#include "dfile_sort.h"


/*
** This function compares key fields between field and bind structures.
*/
int compare_sort_field_bind( const field_t *field, const order_by_t *field_sort_key, const unsigned short *field_key_ndx, const dfile_bind_t *bind, const unsigned short *bind_key_ndx, unsigned short key_tbl_cnt )
{
	int	result;
	const field_t	*fld;
	const dfile_bind_t	*bnd;

	assert( field != (const field_t *)0 );
	assert( field_sort_key != (const order_by_t *)0 );
	assert( field_key_ndx != (const unsigned short *)0 );
	assert( bind != (const dfile_bind_t *)0 );
	assert( bind_key_ndx != (const unsigned short *)0 );

	DEBUG_FUNC_START;

	for ( ; key_tbl_cnt > (unsigned short)0; --key_tbl_cnt ) {
		fld = &field[ *field_key_ndx ];
		bnd = &bind[ *bind_key_ndx ];

		result = compare( fld->value, fld->length, *bnd->field_buffer, *bnd->field_length, field_sort_key->value_type, field_sort_key->ascend_descend );

		if ( result != 0 ) {
			RETURN_INT( result );
		}

		++field_sort_key;
		++field_key_ndx;
		++bind_key_ndx;
	}

	RETURN_INT( 0 );
}
