/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"
#include "sexpr.h"
#include "dfile_sort.h"


/*
** This function maps fields between input merge files and output layout.
*/
int map_merge_fields( unsigned short ***merge_io_field_map, unsigned short ***merge_key_ndx_tbl, dfile_t **dfile_tbl, unsigned short dfile_tbl_cnt, dfile_bind_t **output_sorted_bind, dfile_bind_t *output_bind, unsigned short output_bind_cnt, order_by_t *key_tbl, unsigned short key_tbl_cnt )
{
	dfile_bind_t	*bind, **sorted_bind;
	unsigned short	ndx, bind_cnt;
	unsigned short	**new_io_field_map_tbl;
	unsigned short	**new_key_ndx_tbl;
	size_t	alloc_size;
	dfile_t	*dfile;

	assert( merge_io_field_map != (unsigned short ***)0 );
	assert( merge_key_ndx_tbl != (unsigned short ***)0 );
	assert( dfile_tbl != (dfile_t **)0 );
	assert( output_sorted_bind != (dfile_bind_t **)0 );
	assert( output_bind != (dfile_bind_t *)0 );

	DEBUG_FUNC_START;

	*merge_io_field_map = (unsigned short **)0;
	*merge_key_ndx_tbl = (unsigned short **)0;

	if ( dfile_tbl_cnt == (unsigned short)0 ) {
		/*
		** No files to merge.
		*/
		RETURN_INT( 0 );
	}

	alloc_size = (size_t)dfile_tbl_cnt * sizeof( unsigned short * );
	new_io_field_map_tbl = (unsigned short **)malloc( alloc_size );
	if ( new_io_field_map_tbl == (unsigned short **)0 ) {
		UNIX_ERROR( "malloc() failed" );
		RETURN_INT( -1 );
	}

	alloc_size = (size_t)dfile_tbl_cnt * sizeof( unsigned short * );
	new_key_ndx_tbl = (unsigned short **)malloc( alloc_size );
	if ( new_key_ndx_tbl == (unsigned short **)0 ) {
		UNIX_ERROR( "malloc() failed" );
		RETURN_INT( -1 );
	}

	for ( ndx = (unsigned short)0; ndx < dfile_tbl_cnt; ++ndx ) {
		dfile = dfile_tbl[ ndx ];
		bind = dfile->bind;
		bind_cnt = dfile->bind_cnt;
		sorted_bind = dfile->sorted_bind;

		if ( map_io_fields( &new_io_field_map_tbl[ ndx ], sorted_bind, bind, bind_cnt, output_sorted_bind, output_bind, output_bind_cnt, (unsigned short *)0, key_tbl_cnt, (const char *)0 ) == -1 ) {
			RETURN_INT( -1 );
		}

		if ( assign_order_by_field_offset( &new_key_ndx_tbl[ ndx ], key_tbl, key_tbl_cnt, bind, bind_cnt, sorted_bind ) == -1 ) {
			RETURN_INT( -1 );
		}
	}

	*merge_io_field_map = new_io_field_map_tbl;
	*merge_key_ndx_tbl = new_key_ndx_tbl;

	RETURN_INT( 0 );
}
