/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include <regex.h>
#include <string.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_transform.h"

static int bind_search( dfile_bind_t **, char *, dfile_bind_t **, unsigned short );

/*
** This function assigns bind structure pointer.
*/
int assign_bind( trnsfrm_t *trnsfrm, unsigned short trnsfrm_cnt, dfile_bind_t **input_bind, unsigned short input_bind_cnt, dfile_bind_t **output_bind, unsigned short output_bind_cnt )
{
	assert( trnsfrm != (trnsfrm_t *)0 );
	assert( input_bind != (dfile_bind_t **)0 );
	assert( input_bind_cnt > (unsigned short)0 );
	assert( output_bind != (dfile_bind_t **)0 );
	assert( output_bind_cnt > (unsigned short)0 );

	DEBUG_FUNC_START;

	for ( ; trnsfrm_cnt > (unsigned short)0; --trnsfrm_cnt, ++trnsfrm ) {
		if ( bind_search( &trnsfrm->input_bind, trnsfrm->input_field_name, input_bind, input_bind_cnt ) == -1 ) {
			RETURN_INT( -1 );
		}

		if ( bind_search( &trnsfrm->output_bind, trnsfrm->output_field_name, output_bind, output_bind_cnt ) == -1 ) {
			RETURN_INT( -1 );
		}
	}

	RETURN_INT( 0 );
}

static int bind_search( dfile_bind_t **result, char *field_name, dfile_bind_t **bind, unsigned short bind_cnt )
{
	dfile_bind_t	bind_key, *bind_key_ptr, **bind_result;

	bind_key_ptr = &bind_key;
	bind_key.field_name = field_name;

	bind_result = (dfile_bind_t **)bsearch( (void *)&bind_key_ptr, (void *)bind, (size_t)bind_cnt, sizeof( dfile_bind_t * ), dfile_bind_field_name_cmp );

	if ( bind_result == (dfile_bind_t **)0 ) {
		FPUT_SRC_CODE( stderr );
		(void) fputs( "Field [", stderr );
		(void) fputs( field_name, stderr );
		(void) fputs( "] in control file was not found in record definition.\n", stderr );
		return -1;
	}

	*result = *bind_result;

	return 0;
}
